//	Tundra ENB v0.188
//	OVERSPLIT enbeffect.fx file 
//	Crazily requested by Midhras
//	Geniusly designed by JawZ
//	Crazily burnt, twisted, redesigned by Kyo
//	D-N-I grain and letterboxes
//	Added ApplyGameColorCorrection toggle for main functions
//	Added post-Processes toggle
//	D-N-I Split for ALL functions and Post-Processes
//	Post-Processes range from 1 to 7
//	PP2 modified by Kyo
//	PP6 added by Kyo, basing on Bronze316 modifications
//	PP7 added by Kyo
//	Copyright (c) 2007-2013 Boris Vorontsov
//
//	Tweaking skills adviced - required :P
//------------------------------------------------------------------------------------------------------------------------------------

// Remove or add  //  in front of a  #define  below to disable or enable the various options

// D-N-I PANORAMIC OFFSET - SEE BELOW FOR CLASSIC VIGNETTE AND D-N-I LETTERBOX
//------------------------------------------------------------------------------------------------------------------------------------
/**
 *	SET Panoramic Offset Option - Matso's Code
 *	KYO : you can set different sizes for D, N and I
 *	Bars will slowly increase / decrease when switching from Daytime to Nighttime
 */
//Matso's Letterbox effect (set Your FOV to 80.0  or  85.0  or  90.0 in game for better effect)
	//#define USE_LETTERBOX_EFFECT	1		// blackens top and bottom of the screen 
	#define fLetterboxOffsetDay 		7.8     // size of screen to be blacken (in %) - Bars Size	
	#define fLetterboxOffsetNight 		7.8     // size of screen to be blacken (in %) - Bars Size	
	#define fLetterboxOffsetInterior 	7.8     // size of screen to be blacken (in %) - Bars Size	
/**
 *	CHOOSE screen resolution
 *	Add your own resolution if not included
 *
 *	[1.77777778 ratio]
 */
float2 fvTexelSize = float2(1.0 / 1920.0, 1.0 / 1080.0);		
//float2 fvTexelSize = float2(1.0 / 2560.0, 1.0 / 1440.0);
//float2 fvTexelSize = float2(1.0 / 2880.0, 1.0 / 1620.0);
//float2 fvTexelSize = float2(1.0 / 3200.0, 1.0 / 1800.0);
//float2 fvTexelSize = float2(1.0 / 3449.0, 1.0 / 1940.0);
//float2 fvTexelSize = float2(1.0 / 3552.0, 1.0 / 1998.0);
//float2 fvTexelSize = float2(1.0 / 3840.0, 1.0 / 2160.0);

/**
 *	[1.6 ratio]
 */
//float2 fvTexelSize = float2(1.0 / 1920.0, 1.0 / 1200.0);
//float2 fvTexelSize = float2(1.0 / 1680.0, 1.0 / 1050.0);
//float2 fvTexelSize = float2(1.0 / 3840.0, 1.0 / 2400.0);

/**
 *	[2.35 : 1 ratio]
 */
//float2 fvTexelSize = float2(1.0 / 2538.0, 1.0 / 1080.0);
//float2 fvTexelSize = float2(1.0 / 2869.0, 1.0 / 1221.0);
//float2 fvTexelSize = float2(1.0 / 3200.0, 1.0 / 1362.0);
//float2 fvTexelSize = float2(1.0 / 3760.0, 1.0 / 1600.0);		

//------------------------------------------------------------------------------------------------------------------------------------
// MAIN EFFECT ACTIVATION

	#define POSTPROCESS	7		// Choose which post-processing effect to use - Can be 1-2-3-4-5-6-7
	#define APPLYGAMECOLORCORRECTION 	
	// Above will deactivate the use of vanilla post-processing and only use the ones in here 
	// Above NEEDS to be UNCOMMENTED for Image Space modifiers to kick in
	//#define ENB_FLIPTECHNIQUE 		// This will turn every effect in here off if enabled
//------------------------------------------------------------------------------------------------------------------------------------	

//------------------------------------------------------------------------------------------------------------------------------------
// ADDITIONAL EFFECT ACTIVATION

// For ENB version 0.139 and up have "ENABLE_FLIP_NITE_DAY_FACTOR" disabled and "ENABLE_FLIP_INT_EXT_FACTOR" enabled.
// From ENB version 0.119 and up till 0.138 have "ENABLE_FLIP_NITE_DAY_FACTOR" disabled and "ENABLE_FLIP_INT_EXT_FACTOR" disabled.

	#define ENABLE_FLIP_INT_EXT_FACTOR	// Flips the interior and exterior factor, so that interior settings affect exteriors and vice versa.
	//#define ENABLE_FLIP_NITE_DAY_FACTOR	// Flips the day and night factor, so that day settings affect nights and vice versa.

	
	#define HD6_COLOR_TWEAKS		// Enables a set of Contrast, Brightness and Saturation controls, with in-game adjustment.
	#define HD6_DARKER_NIGHTS		// Enable this to have an extra control for the brightness at night.
//	#define HD6_COLOR_TWEAKS_DNI		// This makes it so the COLOR_TWEAKS is truly seperated to Day, Night and Interior.
//	#define HD6_VIGNETTE			// HD6 own vignette effect.
	#define HD6_COLORSAT_DAYNIGHT		// Another set of RGB Color adjustment.
	#define HD6_BLOOM_DEBLUEIFY		// Removes the blue hue in the bloom.
	#define HD6_PALETTE_MIXER		// Activates or deactivates the use of the enbpalette.bmp commands and DNI separation.
//	#define COLOR_FILTER                    // Adjusts the RGB values seperately, Red, Green and Blue.
	#define COLOR_WHEEL			// This enables more colorization to be had beyond the red, green and blue.
//	#define BLOOM_COLORIZATION		// With this enabled you can adjust the coloization of the bloom.
//	#define COMBINE_BLOOM			// If enabled ENB will use both the ENB bloom and Vanilla bloom together.
	#define USEBLOOM 			// Disable bloom with this if you turn it off in enbseries, compensates for darkening.
//		#define DIFFUSE_BLOOM			// More precise bloom that doesn't bloom the whole screen as HD6 bloom tends to do.
		#define HD6_BLOOM_CRISP			// HD6 - BLOOM v1 - alternate crisp bloom, no hazey mud.
//		#define HD6_BLOOM_SCREEN		// HD6 - BLOOM v2 - alternate bloom (using screen mode). 
//		#define HD6_BLOOM_DEFUZZ		// HD6 - BLOOM v3 - old weird serendipitous code to defuzz bloom.
//		#define HD6_BLOOM_NOBLACK		// HD6 - BLOOM v4 - remove black from bloom.

//	#define ENABLE_SEPIATONE	        // Enable sepia tone effect (turns everything orange) - DNI SEPARATED
//	#define ENABLE_GRAIN			// Enable grain effect (puts speckles on screen) - DNI SEPARATED
//	#define ENABLE_LETTERBOX_BARS   	// Enable cinematic bars (black bars at top and bottom) - DNI SEPARATED
//------------------------------------------------------------------------------------------------------------------------------------
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// MODIFY THESE VALUES BELOW TO TWEAK VARIOUS COLOR PROCESSING OPTIONS
// SET ALL VALUES TO 1.0 AND IT WILL GET A "VANILLA LOOKING" COLOR PROCESSING.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//------------------------------------------------------------------------------------------------------------------------------------
// HD6_COLOR_TWEAKS - Color Balance and Brightness, Contrast adjustment

	//			  Red, Green, Blue

	#if (POSTPROCESS==5)
	float3 rgbd 	= float3( 1.00, 0.97, 1.02 ); 		// RGB balance Day
	float3 rgbn 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Night
	float3 rgbi 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Interior
	#else
	#if (POSTPROCESS==2)
	float3 rgbd 	= float3( 1.00, 0.97, 1.02 ); 		// RGB balance Day
	float3 rgbn 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Night
	float3 rgbi 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Interior
	#else
	#if (POSTPROCESS==6)
	float3 rgbd 	= float3( 1.00, 0.97, 1.02 ); 		// RGB balance Day
	float3 rgbn 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Night
	float3 rgbi 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Interior
	#else
	#if (POSTPROCESS==7)				 		
	float3 rgbd 	= float3( 1.00, 0.97, 1.02 ); 		// RGB balance Day
	float3 rgbn 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Night
	float3 rgbi 	= float3( 1.02, 1.10, 1.14 ); 		// RGB balance Interior
	  
          #endif
	 #endif
	#endif
       #endif

//-------------------------------------------------------------------------------------------------------------------------
/**
 *	SET Screen Dot size - Set to 0.0 to hide
 *	Change size of keypress dot here, can be 0 to hide it
 */	
	float dotsize = 0.002;		//0.02

//-------------------------------------------------------------------------------------------------------------------------
/**
 *	SET Brightness, Contrast, Saturation, Darkening level
 *	Darker Nights ( Night Keypress 5+Pageup/down, Night, Day )	
 *	keypress 5,6:	  night, day		night, day
 */	

#ifdef HD6_COLOR_TWEAKS_DNI

	// If you have set #define HD6_COLOR_TWEAKS_DNI, these following will be the values to change.

#ifndef APPLYGAMECOLORCORRECTION
//[GAMECOLORCORRECTION is OFF]
#if (POSTPROCESS==5)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else
#if (POSTPROCESS==2)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else
#if (POSTPROCESS==6)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==7)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
	  #endif
	 #endif
	#endif
       #endif
#else

//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

//[GAMECOLORCORRECTION is ON]
#if (POSTPROCESS==5)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==2)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==6)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==7)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
	  #endif
	 #endif
	#endif
       #endif
 #endif

#endif

//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	
	// If you have set // #define HD6_COLOR_TWEAKS_DNI, these following will be the values to change.

#ifndef APPLYGAMECOLORCORRECTION
//[GAMECOLORCORRECTION is OFF]
#if (POSTPROCESS==5)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else
#if (POSTPROCESS==2)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else
#if (POSTPROCESS==6)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==7)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
	  #endif
	 #endif
	#endif
       #endif
#else

//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

//[GAMECOLORCORRECTION is ON]
#if (POSTPROCESS==5)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==2)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==6)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
#else	
#if (POSTPROCESS==7)
	float4 uctbrt1 	= float4( 0.30, 0.30, 		0.75, 0.93) ; 	// Brightness Night, Day (Before contrast adjustment)
	float4 uctbrt2	= float4( 0.30, 0.30, 		0.75, 0.96 ); 	// Brightness Night, Day (After contrast adjustment)
	float4 uctcon 	= float4( 0.90, 0.90, 		0.80, 0.48 ); 	// Contrast Night, Day
	float4 uctsat	= float4( 0.20, -0.80, 		0.90, 0.70 ); 	// Saturation Night, Day (This will also desaturate the night)
	  #endif
	 #endif
	#endif
       #endif
 #endif

//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
//
// HD6_DARKER_NIGHTS - Alters the brightness of Night only( Night Keypress 1+Pageup/down, Night, Day )
	#ifdef HD6_DARKER_NIGHTS
	//			    Night, Day		Night, Day
	#if (POSTPROCESS==5)
	float4 darkenby1 = float4( 0.45, -.15, 		0.25, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.15, 	0.45, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.65, 	0.5, -0.35 );
	#else
	#if (POSTPROCESS==2)
	float4 darkenby1 = float4( 0.45, -.15, 		0.25, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.15, 	0.45, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.65, 	0.5, -0.35 );
	#else
	#if (POSTPROCESS==6)
	float4 darkenby1 = float4( 0.45, -.15, 		0.25, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.15, 	0.45, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.65, 	0.5, -0.35 );
	#else
	#if (POSTPROCESS==7)
	float4 darkenby1 = float4( 0.45, -.15, 		0.25, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.15, 	0.45, -0.25 );
	//float4 darkenby1 = float4( 0.45, -.65, 	0.5, -0.35 );

	   #endif
  	  #endif
	 #endif
	#endif
	
	#endif
//
//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// KYO : more to come :P
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
// HD6_VIGNETTE - Darkens and blurs edges of the screen which increases focus on center

	float rovigpwr = 0.4;			// For Round vignette
	float2 sqvigpwr = float2( 0.0, 0.1 );	// For square vignette: (top, bottom)
	float vsatstrength = 0.85;		// How saturated vignette is
	float vignettepow = 1.5;		// For Round vignette, higher pushes it to the corners and increases contrast/sharpness			
	float vstrengthatnight = 0.2;		// How strong vignette is at night
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// HD6_COLORSAT_DAYNIGHT 
/**
 *	SET Saturation balance
 *	Alters saturation separately for day, night and interiors	
 */	
//				Red, Green, Blue
#if (POSTPROCESS==5)
	float3 dnsatd = float3( 1.00, 1.00, 1.00 );	// Daytime Saturation, Red, Green, Blue
	float3 dnsatn = float3( 0.93, 0.90, 0.95 );	// Nighttime Saturation, Red, Green, Blue
	float3 dnsati = float3( 0.93, 0.90, 0.95 );	// Interior Saturation, Red, Green, Blue
#else
#if (POSTPROCESS==2)
	float3 dnsatd = float3( 1.00, 1.00, 1.00 );	// Daytime Saturation, Red, Green, Blue
	float3 dnsatn = float3( 0.93, 0.90, 0.95 );	// Nighttime Saturation, Red, Green, Blue
	float3 dnsati = float3( 0.93, 0.90, 0.95 );	// Interior Saturation, Red, Green, Blue
#else
#if (POSTPROCESS==6)
	float3 dnsatd = float3( 1.00, 1.00, 1.00 );	// Daytime Saturation, Red, Green, Blue
	float3 dnsatn = float3( 0.93, 0.90, 0.95 );	// Nighttime Saturation, Red, Green, Blue
	float3 dnsati = float3( 0.93, 0.90, 0.95 );	// Interior Saturation, Red, Green, Blue
#else
#if (POSTPROCESS==7)					   	
	float3 dnsatd = float3( 1.00, 1.00, 1.00 );	// Daytime Saturation, Red, Green, Blue
	float3 dnsatn = float3( 0.93, 0.90, 0.95 );	// Nighttime Saturation, Red, Green, Blue
	float3 dnsati = float3( 0.93, 0.90, 0.95 );	// Interior Saturation, Red, Green, Blue

  	  #endif
	 #endif
	#endif
       #endif
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// HD6_BLOOM_DEBLUEIFY 
/**
 *	SET Deblueify balance
 *	Removes blue tint from bloom, most apparent in distant fog	
 */	
//			       Red, Green, Blue
#if (POSTPROCESS==5)
	float3 bsatd = float3( 1.25, 1.04, 1.25 );	// Daytime Deblueify, Red, Green, Blue
	float3 bsatn = float3( 1.25, 1.13, 1.25 );	// Nighttime Deblueify, Red, Green, Blue
	float3 bsati = float3( 1.25, 1.19, 1.30 );	// Interior Deblueify, Red, Green, Blue
#else
#if (POSTPROCESS==2)
	float3 bsatd = float3( 1.25, 1.04, 1.25 );	// Daytime Deblueify, Red, Green, Blue
	float3 bsatn = float3( 1.25, 1.13, 1.25 );	// Nighttime Deblueify, Red, Green, Blue
	float3 bsati = float3( 1.25, 1.19, 1.30 );	// Interior Deblueify, Red, Green, Blue
#else	
#if (POSTPROCESS==6)
	float3 bsatd = float3( 1.25, 1.04, 1.25 );	// Daytime Deblueify, Red, Green, Blue
	float3 bsatn = float3( 1.25, 1.13, 1.25 );	// Nighttime Deblueify, Red, Green, Blue
	float3 bsati = float3( 1.25, 1.19, 1.30 );	// Interior Deblueify, Red, Green, Blue
#else	
#if (POSTPROCESS==7)
	float3 bsatd = float3( 1.25, 1.04, 1.25 );	// Daytime Deblueify, Red, Green, Blue
	float3 bsatn = float3( 1.25, 1.13, 1.25 );	// Nighttime Deblueify, Red, Green, Blue
	float3 bsati = float3( 1.25, 1.19, 1.30 );	// Interior Deblueify, Red, Green, Blue

  	  #endif
	 #endif
	#endif
       #endif

	//[RGB Alternatives]
	//float3 nsat = float3( 1.25, 1.03, 1.25);  // heavy distinct colours
	//float3 nsat = float3( 1.60, 1.55, 1.65);  // heavier distinct colours
	//float3 nsat = float3( 0.2, 0.49, 0.95 );  // stark blues (cold feeling)
	//float3 nsat = float3( 0.76, 0.65, 0.75 ); // deep reds (warm feeling)
	//float3 nsat = float3( 0.50, 0.75, 0.58 ); // lush greens (vibrant, or eerily sickening feeling)
	//float3 nsat = float3( 0.80, 0.73, 0.75 ); // vanilla-like warmer
	//float3 nsat = float3( 0.7, 0.7, 0.7);     // vanilla
	//float3 nsat = float3( 0.80, 0.65, 0.75 ); // vanilla-like warmer curved
	//float3 nsat = float3( 0.80, 0.75, 0.72 ); // vanilla-like warmer

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// DIFFUSE BLOOM - More precise bloom that doesn't bloom the whole screen as HD6 bloom tends to do.

//DAY
	float REDDay = 1.0;		// Controls the red level in the diffuse bloom
	float GREENDay = 1.0;		// Controls the green level in the diffuse bloom
	float BLUEDay = 1.0;		// Controls the blue level in the diffuse bloom

	float SatDay = 1.0;		// Controls the saturation of the diffuse bloom
	float LumaDay = 0.333;		// Controls the Luminosity/brightness of the diffuse bloom
	float PowDay = 0.333;		// Dampens the bloom, making it less visible
	float Pow2Day = 0.0001;		// Dampens the bloom, making it less visible
		
//NIGHT
	float REDNight = 1.0;		// Controls the red level in the diffuse bloom
	float GREENNight = 1.0;		// Controls the green level in the diffuse bloom
	float BLUENight = 1.0;		// Controls the blue level in the diffuse bloom

	float SatNight = 1.0;		// Controls the saturation of the diffuse bloom
	float LumaNight = 0.333;	// Controls the Luminosity/brightness of the diffuse bloom
	float PowNight = 0.333;		// Dampens the bloom, making it less visible
	float Pow2Night = 0.0001;	// Dampens the bloom, making it less visible
		
//INTERIOR	
	float REDInterior = 1.0;	 // Controls the red level in the diffuse bloom
	float GREENInterior = 1.0;	 // Controls the green level in the diffuse bloom
	float BLUEInterior = 1.0;	 // Controls the blue level in the diffuse bloom

	float SatInterior = 1.0;	 // Controls the saturation of the diffuse bloom
	float LumaInterior = 0.333;	 // Controls the luminosity/brightness of the diffuse bloom
	float PowInterior = 0.333;	 // Dampens the bloom, making it less visible
	float Pow2Interior = 0.0001; 	 // Dampens the bloom, making it less visible
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// HD6 BLOOM CRISP - Alternate crisp bloom, no hazey mud.

//DAY
	float3 LumCoeffDay = ( 0.2125, 0.7154, 0.0721 );	// Increases brightness around "bloomy" spots
	float3 AvgLuminDay = ( 0.5, 0.5, 0.5 );			// Increases contrast around "bloomy" spots
	
	float TrigDay = 0.0;				// Limits what triggers a bloom
	float SBrightDay = 0.7;				// Limits bloom to superbright spots only

	float CBrightnessDay = 1.0;			// Adjust the bloom brightness
	float CContrastDay = 1.0;			// Adjust the bloom contrast
	float CSaturationDay = 0.7;			// Adjust the bloom saturation

	float BrightnessModDay = 0.23;			// Compensate the brightness when no bloom is used
	float BrightnessMultDay = 1.4;			// Compensate the brightness when no bloom is used

	float CompSBDay = 1.0;				// Limits where the bloom will "bloom"
	float BloomStrDay = 1.0;			// How strong the bloom will be

	float BloomBlendDay = 0.6;			// How much blend there will be between ENB and Vanilla bloom
	float BlendCompDay = 0.7;			// Compensate for brightening caused by above bloom blend
		
//NIGHT
	float3 LumCoeffNight = ( 0.2125, 0.7154, 0.0721 );	// Increases brightness around "bloomy" spots
	float3 AvgLuminNight = ( 0.5, 0.5, 0.5 );		// Increases contrast around "bloomy" spots
	
	float TrigNight = 0.18;		 		// Limits what triggers a bloom
	float SBrightNight = 0.7;			// Limits bloom to superbright spots only

	float CBrightnessNight = 1.0;			// Adjust the bloom brightness
	float CContrastNight = 1.1;			// Adjust the bloom contrast
	float CSaturationNight = 0.8;			// Adjust the bloom saturation

	float BrightnessModNight = 0.12;		// Compensate the brightness when no bloom is used
	float BrightnessMultNight = 1.1;		// Compensate the brightness when no bloom is used

	float CompSBNight = 1.0;			// Limits where the bloom will "bloom"
	float BloomStrNight = 1.0;			// How strong the bloom will be

	float BloomBlendNight = 0.7;			// How much blend there will be between ENB and Vanilla bloom
	float BlendCompNight = 0.8;			// Compensate for brightening caused by above bloom blend
		
//INTERIOR
	float3 LumCoeffInterior = ( 0.2125, 0.7154, 0.0721 );	// Increases brightness around "bloomy" spots
	float3 AvgLuminInterior = ( 0.5, 0.5, 0.5 );		// Increases contrast around "bloomy" spots
	
	float TrigInterior = 0.18;			// Limits what triggers a bloom
	float SBrightInterior = 0.7;			// Limits bloom to superbright spots only

	float CBrightnessInterior = 1.0;		// Adjust the bloom brightness
	float CContrastInterior = 1.1;			// Adjust the bloom contrast
	float CSaturationInterior = 0.8;		// Adjust the bloom saturation

	float BrightnessModInterior = 0.12;		// Compensate the brightness when no bloom is used
	float BrightnessMultInterior = 1.1;		// Compensate the brightness when no bloom is used

	float CompSBInterior = 1.0;			// Limits where the bloom will "bloom"
	float BloomStrInterior = 1.0;			// How strong the bloom will be

	float BloomBlendInterior = 0.7;			// How much blend there will be between ENB and Vanilla bloom
	float BlendCompInterior = 0.8;			// Compensate for brightening caused by above bloom blend
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Color settings
//NOTE: IF YOU SET BOTH RED, GREEN AND BLUE AT THE SAME VALUE IT WILL ACT AS AN BRIGHTNESS COMMAND.
//					    Red, Green, Blue
float3	EColorFilterDay 	 = float3 ( 1.0, 1.0, 1.0 );	// Adjusts the RGB values seperately, Red, Green and Blue.
float3	EColorFilterNight 	 = float3 ( 1.0, 1.0, 1.0 );	// Adjusts the RGB values seperately, Red, Green and Blue.
float3	EColorFilterInterior 	 = float3 ( 1.0, 1.0, 1.0 );	// Adjusts the RGB values seperately, Red, Green and Blue.

// Color wheel settings
float	MAGENTADay		= 1.012;	// Adds the amount of magenta color
float	MAGENTANight		= 1.008;	// Adds the amount of magenta color
float	MAGENTAInterior		= 1.0;		// Adds the amount of magenta color
float	CYANDay			= 1.0;		// Adds the amount of cyan color
float	CYANNight		= 1.0;		// Adds the amount of cyan color
float	CYANInterior		= 1.0;		// Adds the amount of cyan color
float	YELLOWDay		= 1.008;	// Adds the amount of yellow color
float	YELLOWNight		= 1.0;		// Adds the amount of yellow color
float	YELLOWInterior		= 1.0;		// Adds the amount of yellow color

float	MAGENTAsubDay		= 0.0;		// Subtracts the amount of magenta color
float	MAGENTAsubNight		= 0.0;		// Subtracts the amount of magenta color
float	MAGENTAsubInterior	= 0.0;		// Subtracts the amount of magenta color
float	CYANsubDay		= 0.0;		// Subtracts the amount of cyan color
float	CYANsubNight		= 0.0;		// Subtracts the amount of cyan color
float	CYANsubInterior		= 0.0;		// Subtracts the amount of cyan color
float	YELLOWsubDay		= 0.0;		// Subtracts the amount of yellow color
float	YELLOWsubNight		= 0.0;		// Subtracts the amount of yellow color
float	YELLOWsubInterior	= 0.0;		// Subtracts the amount of yellow color
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Bloom colorization settings
//NOTE: IF YOU SET BOTH RED, GREEN AND BLUE AT THE SAME VALUE IT WILL ACT AS AN AMOUNT COMMAND.

float	REDbloommultDay		= 1.0;		// Increases the amount of red color there is in bloom
float	REDbloommultNight	= 1.0;		// Increases the amount of red color there is in bloom
float	REDbloommultInterior	= 1.0;		// Increases the amount of red color there is in bloom
float	GREENbloommultDay	= 1.0;		// Increases the amount of green color there is in bloom
float	GREENbloommultNight	= 1.0;		// Increases the amount of green color there is in bloom
float	GREENbloommultInterior	= 1.0;		// Increases the amount of green color there is in bloom
float	BLUEbloommultDay	= 1.0;		// Increases the amount of blue color there is in bloom
float	BLUEbloommultNight	= 1.0;		// Increases the amount of blue color there is in bloom
float	BLUEbloommultInterior	= 1.0;		// Increases the amount of blue color there is in bloom

// Bloom color wheel settings
float	MAGENTAbloomDay		= 1.0;		// Increases the amount of magenta color there is in bloom
float	MAGENTAbloomNight	= 1.0;		// Increases the amount of magenta color there is in bloom
float	MAGENTAbloomInterior	= 1.0;		// Increases the amount of magenta color there is in bloom
float	CYANbloomDay		= 1.0;		// Increases the amount of cyan color there is in bloom
float	CYANbloomNight		= 1.0;		// Increases the amount of cyan color there is in bloom
float	CYANbloomInterior	= 1.0;		// Increases the amount of cyan color there is in bloom
float	YELLOWbloomDay		= 1.0;		// Increases the amount of yellow color there is in bloom
float	YELLOWbloomNight	= 1.0;		// Increases the amount of yellow color there is in bloom
float	YELLOWbloomInterior	= 1.0;		// Increases the amount of yellow color there is in bloom

//NOTE: THE SETTINGS BELOW SHOULD BE INCREASED WITH SMALL AMOUNTS AS THEY IMPACT HEAVILY ON THE SCENE EVEN WITH A VALUE OF 1.0.
float	REDbloomsubDay		= 0.0;		// Alters the perception of red color in bloom
float	REDbloomsubNight	= 0.0;		// Alters the perception of red color in bloom
float	REDbloomsubInterior	= 0.0;		// Alters the perception of red color in bloom
float	GREENbloomsubDay	= 0.0;		// Alters the perception of green color in bloom
float	GREENbloomsubNight	= 0.0;		// Alters the perception of green color in bloom
float	GREENbloomsubInterior	= 0.0;		// Alters the perception of green color in bloom
float	BLUEbloomsubDay		= 0.0;		// Alters the perception of blue color in bloom
float	BLUEbloomsubNight	= 0.0;		// Alters the perception of blue color in bloom
float	BLUEbloomsubInterior	= 0.0;		// Alters the perception of blue color in bloom
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// PALETTE MIXER - controls the intensity of the enbpalette.bmp file IN THE FINAL MIX
/**
 *	SET strength of Palette texture in overall color mix
 *	WORKS INDEPENDANTLY for PP2, 5, 6 and 7
 *	WORKS INDEPENDANTLY with APPLYGAMECOLORCORRECTION TOGGLE
 */
#ifndef APPLYGAMECOLORCORRECTION

//[GAMECOLORCORRECTION is OFF]	
#if (POSTPROCESS==5)
	float palmixDay=0.4;		
	float palmixNight=0.5;
	float palmixInterior=0.5;
#else
#if (POSTPROCESS==2)
	float palmixDay=0.5;	
	float palmixNight=0.5;
	float palmixInterior=0.5;
#else
#if (POSTPROCESS==6)
	float palmixDay=0.5;	
	float palmixNight=0.5;
	float palmixInterior=0.5;
#else
#if (POSTPROCESS==7)
	float palmixDay=0.35;		
	float palmixNight=0.45;
	float palmixInterior=0.5;

   #endif
  #endif
 #endif 
#endif

#else

//[GAMECOLORCORRECTION is ON]	
#if (POSTPROCESS==5)
	float palmixDay=0.35;		
	float palmixNight=0.45;		
	float palmixInterior=0.5;
#else
#if (POSTPROCESS==2)
	float palmixDay=0.5;	
	float palmixNight=0.5;
	float palmixInterior=0.5;
#else
#if (POSTPROCESS==6)
	float palmixDay=0.5;	
	float palmixNight=0.5;
	float palmixInterior=0.5;
#else
#if (POSTPROCESS==7)
	float palmixDay=0.35;		
	float palmixNight=0.45;
	float palmixInterior=0.5;

   #endif
  #endif
 #endif 
#endif

#endif

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Sepia Tone settings - This will make it look like an old photograph.

// DAY
	float3 fSepiaColorDay = float3( 1.0, 0.85 , 0.7 );		// Controls color of sepia tone.
	float fSepiaDesaturationDay = 0.5;				// Controls amount of sepia color applied to image.
	float fSepiaExposureDay = 1.2;					// Controls exposure of sepia tone.

// NIGHT
	float3 fSepiaColorNight = float3( 1.0, 0.85 , 0.7 );		// Controls color of sepia tone.
	float fSepiaDesaturationNight = 0.5;				// Controls amount of sepia color applied to image.
	float fSepiaExposureNight = 1.2;				// Controls exposure of sepia tone.

// INTERIOR
	float3 fSepiaColorInterior = float3( 1.0, 0.85 , 0.7 );		// Controls color of sepia tone.
	float fSepiaDesaturationInterior = 0.5;				// Controls amount of sepia color applied to image.
	float fSepiaExposureInterior = 1.2;				// Controls exposure of sepia tone.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Grain settings - Adds a grain effect to the screen.

// DAY
	float fGrainIntensityDay = 0.1;			// Controls the intensity of the grain effect.
	float fGrainSaturationDay = 0.25;		// Controls the color saturation of the grain effect.
	float fGrainMotionDay = 0.05;		//0.075;		// Controls how rapidly the grain effect changes over time.

// NIGHT
	float fGrainIntensityNight = 0.1;		// Controls the intensity of the grain effect.
	float fGrainSaturationNight = 0.25;		// Controls the color saturation of the grain effect.
	float fGrainMotionNight = 0.05;		//0.075;		// Controls how rapidly the grain effect changes over time.

// INTERIOR
	float fGrainIntensityInterior = 0.1;		// Controls the intensity of the grain effect.
	float fGrainSaturationInterior = 0.25;		// Controls the color saturation of the grain effect.
	float fGrainMotionInterior = 0.05;	//0.075;		// Controls how rapidly the grain effect changes over time.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Letterbox settings - Adds widescreen bars at the bottom and top of the screen.

	float fLetterboxBarHeightDay = 0.078;		// Controls the height of cinematic bars. Default: 0.1.
	float fLetterboxBarHeightNight = 0.078;		// Controls the height of cinematic bars. Default: 0.1.
	float fLetterboxBarHeightInterior = 0.078;	// Controls the height of cinematic bars. Default: 0.1.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

float random(in float2 uv)
{
    float2 noise = (frac(sin(dot(uv , float2(12.9898,78.233) * 2.0)) * 43758.5453));
    return abs(noise.x + noise.y) * 0.5;
}

float smootherstep(float edge0, float edge1, float x)
{
    x = saturate((x - edge0)/(edge1 - edge0)); 
    return x*x*(3 - 2*x);
}

//+++++++KYO : DO NOT CHANGE ANYTHING HERE!!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Keyboard controlled temporary variables (in some versions exists in the config file).
// Press and hold key 1,2,3...8 together with PageUp or PageDown to modify. By default all set to 1.0
	float4	tempF1;			// 0,1,2,3
	float4	tempF2;			// 5,6,7,8
	float4	tempF3;			// 9,0
	float4	Timer;			// x=generic timer in range 0..1, period of 16777216 ms (4.6 hours), w=frame time elapsed (in seconds)
	float4	ScreenSize;		// x=Width, y=1/Width, z=ScreenScaleY, w=1/ScreenScaleY
	float	ENightDayFactor;	// changes in range 0..1, 0 means that night time, 1 - day time
	float	EInteriorFactor;	// changes 0 or 1. 0 means that exterior, 1 - interior
	float	EBloomAmount;		// enb version of bloom applied, ignored if original post processing used
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// POST PROCESSES SETTINGS
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/**
 *	Post - Processes 2, 6 and 7 include MOOD COLOURING
 *	Mood Colouring impacts overall ambient lighting tints, colors, intensities
 *	You can set it differently for Days, Nights and Interiors
 *	Settings work as follow :
 *
 *	float fRatioDay = 	blend ratio Day (range 0-1)
 *	float moodRDay =  	mood color red component Day
 *	float moodGDay =  	mood color green component Day
 *	float moodBDay =  	mood color blue component Day	 
 *	float ContrastDay =	contrast level Day
 *	float ExposureDay =	exposure level Day
 */
//------------------------------------------------------------------------------------------------------------------------
//POSTPROCESS v1 by ENB

//DAY
	float	EAdaptationMinV1Day = 0.01;
	float	EAdaptationMaxV1Day = 0.07;

	float	EContrastV1Day = 0.95;
	float	EColorSaturationV1Day = 1.2;
	float	EToneMappingCurveV1Day = 6.0;

//NIGHT
	float	EAdaptationMinV1Night = 0.01;
	float	EAdaptationMaxV1Night = 0.15;

	float	EContrastV1Night = 0.95;
	float	EColorSaturationV1Night = 1.0;
	float	EToneMappingCurveV1Night = 6.0;

//INTERIOR
	float	EAdaptationMinV1Interior = 0.01;
	float	EAdaptationMaxV1Interior = 0.15;

	float	EContrastV1Interior = 0.95;
	float	EColorSaturationV1Interior = 1.0;
	float	EToneMappingCurveV1Interior = 6.0;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//------------------------------------------------------------------------------------------------------------------------------------
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//POSTPROCESS v2 by ENB - Modified by KYO
#if (POSTPROCESS==2)

//DAY SETTINGS -------------------------------
	float	EBrightnessV2Day=0.17;
	float	EAdaptationMinV2Day=0.019;
	float	EAdaptationMaxV2Day=0.021;	
	float	EToneMappingCurveV2Day=100.0;						
	float	EIntensityContrastV2Day=2.1;
	float	EToneMappingOversaturationV2Day=500.0;
	float	EColorSaturationV2Day=1.7;

//Mood Colouring Day
	float	fRatioDay = 0.285;	
	float	moodRDay = 0.70;		
	float	moodGDay = 0.58;		
	float	moodBDay = 0.65;			 
	float	ContrastDay = 0.085;
	float	ExposureDay = 0.05;	

					
//NIGHT	SETTINGS------------------------------					
	float	EBrightnessV2Night=0.85;
	float	EAdaptationMinV2Night=0.1;
	float	EAdaptationMaxV2Night=0.15;
	float	EToneMappingCurveV2Night=30.7;
	float	EIntensityContrastV2Night=1.96;
	float	EToneMappingOversaturationV2Night=35.0;
	float	EColorSaturationV2Night=1.7;

//Mood Colouring Night
	float	fRatioNight = 0.475;	
	float	moodRNight = 1.05;	
	float	moodGNight = 0.58;	
	float	moodBNight = 0.65;		 
	float	ContrastNight = 0.085;
	float	ExposureNight = 0.05;


//INTERIOR SETTINGS----------------------------					
	float	EBrightnessV2Interior=0.85;
	float	EAdaptationMinV2Interior=0.1;
	float	EAdaptationMaxV2Interior=0.15;
	float	EToneMappingCurveV2Interior=30.7;
	float	EIntensityContrastV2Interior=1.96;
	float	EToneMappingOversaturationV2Interior=35.0;
	float	EColorSaturationV2Interior=1.7;

//Mood Colouring Interior
	float	fRatioInterior = 0.475;	
	float	moodRInterior = 1.05;	
	float	moodGInterior = 0.57;	
	float	moodBInterior = 0.65;		 
	float	ContrastInterior = 0.10;
	float   ExposureInterior = 0.05;

#endif

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//------------------------------------------------------------------------------------------------------------------------------------
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//POSTPROCESS v3 by ENB

//DAY
	float	EAdaptationMinV3Day = 0.05;
	float	EAdaptationMaxV3Day = 0.125;

	float	EToneMappingCurveV3Day = 8.0;
	float	EToneMappingOversaturationV3Day = 60.0;

//NIGHT
	float	EAdaptationMinV3Night = 0.05;
	float	EAdaptationMaxV3Night = 0.125;

	float	EToneMappingCurveV3Night = 4.0;
	float	EToneMappingOversaturationV3Night = 60.0;

//INTERIOR
	float	EAdaptationMinV3Interior = 0.05;
	float	EAdaptationMaxV3Interior = 0.125;

	float	EToneMappingCurveV3Interior = 4.0;
	float	EToneMappingOversaturationV3Interior = 60.0;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//------------------------------------------------------------------------------------------------------------------------------------
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//POSTPROCESS v4 by ENB

//DAY
	float	EAdaptationMinV4Day = 0.2;
	float	EAdaptationMaxV4Day = 0.125;

	float	EBrightnessCurveV4Day = 0.7;
	float	EBrightnessMultiplierV4Day = 0.45;
	float	EBrightnessToneMappingCurveV4Day = 0.5;

//NIGHT
	float	EAdaptationMinV4Night = 0.2;
	float	EAdaptationMaxV4Night = 0.125;

	float	EBrightnessCurveV4Night = 0.7;
	float	EBrightnessMultiplierV4Night = 0.45;
	float	EBrightnessToneMappingCurveV4Night = 0.5;

//INTERIOR
	float	EAdaptationMinV4Interior = 0.2;
	float	EAdaptationMaxV4Interior = 0.125;

	float	EBrightnessCurveV4Interior = 0.7;
	float	EBrightnessMultiplierV4Interior = 0.45;
	float	EBrightnessToneMappingCurveV4Interior = 0.5;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//------------------------------------------------------------------------------------------------------------------------------------
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//POSTPROCESS v5 by HD6 based on Post-Process v2
#if (POSTPROCESS==5)

//DAY
	float	EAdaptationMinV5Day = 0.12;
	float	EAdaptationMaxV5Day = 0.29;

	float	EToneMappingCurveV5Day = 3.0;
	float	EIntensityContrastV5Day = 2.2;         //2.2
	float	EColorSaturationV5Day = 3.1;
	float	HCompensateSatV5Day = 2.0;

//Mood Colouring Day
	float	fRatioDay = 0.0;	
	float 	moodRDay = 0.00;	
	float 	moodGDay = 0.00;	
	float 	moodBDay = 0.00;	
	float 	ContrastDay = 0.25;	
	float 	ExposureDay = 0.0;

//NIGHT
	float	EAdaptationMinV5Night = 0.12;
	float	EAdaptationMaxV5Night = 0.29;

	float	EToneMappingCurveV5Night = 2.0;
	float	EIntensityContrastV5Night = 2.0;
	float	EColorSaturationV5Night = 2.125;
	float	HCompensateSatV5Night = 1.25;

//Mood Colouring Night
	float	fRatioNight = 0.0;	
	float 	moodRNight = 0.01;	
	float 	moodGNight = 0.00;	
	float 	moodBNight = 0.02;	
	float 	ContrastNight = 0.9;	
	float 	ExposureNight = 0.0;

//INTERIOR
	float	EAdaptationMinV5Interior = 0.12;
	float	EAdaptationMaxV5Interior = 0.29;

	float	EToneMappingCurveV5Interior = 2.0;
	float	EIntensityContrastV5Interior = 2.0;
	float	EColorSaturationV5Interior = 2.665;
	float	HCompensateSatV5Interior = 2.0;

//Mood Colouring Interior
	float	fRatioInterior = 0.0;	
	float 	moodRInterior = 0.1;	
	float 	moodGInterior = 0.0;	
	float 	moodBInterior = 0.1;	
	float 	ContrastInterior = 0.85;	
	float 	ExposureInterior = 0.0;
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//POSTPROCESS 6 by KYO based on Bronze316's PPv2
#if (POSTPROCESS==6)

//DAY SETTINGS -------------------------------
	float	EBrightnessV6Day=0.4;				//1.0
	float	EAdaptationMinV6Day=0.06375;
	float	EAdaptationMaxV6Day=0.19125;
	float	EToneMappingCurveV6Day=8.0;
	float	EIntensityContrastV6Day=2.316;
	float	EColorSaturationV6Day=3.0;
	float	EToneMappingOversaturationV6Day=100188.0;

//These are disabled below
	float	newEBrightnessCurveV6Day=2.9;
	float	newEBrightnessMultiplierV6Day=2.6;
	float	newEBrightnessToneMappingCurveV6Day=2.8;

//Mood Colouring Day
	float 	fRatioDay = 0.285;	
	float 	moodRDay = 0.70;		
	float 	moodGDay = 0.58;		
	float 	moodBDay = 0.65;			 
	float	ContrastDay = 0.085;
	float   ExposureDay = 0.05;


//NIGHT	SETTINGS------------------------------	
	float	EBrightnessV6Night=0.2;				//1.0
	float	EAdaptationMinV6Night=0.03;
	float	EAdaptationMaxV6Night=0.09;
	float	EToneMappingCurveV6Night=8.0;
	float	EIntensityContrastV6Night=2.316;
	float	EColorSaturationV6Night=3.0;
	float	EToneMappingOversaturationV6Night=197100.0;
	
//These are disabled below
	float	newEBrightnessCurveV6Night=2.3;
	float	newEBrightnessMultiplierV6Night=1.7;
	float	newEBrightnessToneMappingCurveV6Night=2.3;

//Mood Colouring Night
	float 	fRatioNight = 0.475;	
	float 	moodRNight = 1.05;	
	float 	moodGNight = 0.58;	
	float 	moodBNight = 0.65;	 
	float	ContrastNight = 0.085;
	float   ExposureNight = 0.05;


//INTERIOR SETTINGS----------------------------
	float	EBrightnessV6Interior=1.0;			//1.0
	float	EAdaptationMinV6Interior=0.16;
	float	EAdaptationMaxV6Interior=0.29;
	float	EToneMappingCurveV6Interior=5.0;
	float	EIntensityContrastV6Interior=2.316;
	float	EColorSaturationV6Interior=3.0;
	float	EToneMappingOversaturationV6Interior=197100.0;

//These are disabled below
	float	newEBrightnessCurveV6Interior=2.3;
	float	newEBrightnessMultiplierV6Interior=1.7;
	float	newEBrightnessToneMappingCurveV6Interior=2.3;

//Mood Colouring Interior
	float 	fRatioInterior = 0.475;	
	float 	moodRInterior = 1.05;	
	float 	moodGInterior = 0.57;	
	float 	moodBInterior = 0.65;		 
	float	ContrastInterior = 0.10;
	float   ExposureInterior = 0.05;

#endif
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//POSTPROCESS 7 by KYO
#if (POSTPROCESS==7)

//DAY SETTINGS ////////////////////////////////
	float	EBrightnessV7Day=1.0;				//1.025
	float	EAdaptationMinV7Day=0.16;                       //0.16
	float	EAdaptationMaxV7Day=0.29;                       //0.29
	float 	EToneMappingCurveV7Day=3.6;			//4.875
	float 	EIntensityContrastV7Day=2.395;			//2.395
	
//APPLYGAMECOLORCORRECTION is OFF (//)	
	#ifndef APPLYGAMECOLORCORRECTION
	float	EColorSaturationV7Day = 2.1; 
	float 	HCompensateSatV7Day = 1.1; 	
#else
//APPLYGAMECOLORCORRECTION is ON	
	float	EColorSaturationV7Day = 2.8; 			//1.65
	float 	HCompensateSatV7Day =1.2; 	
#endif	

//Mood Colouring Day
	float	fRatioDay = 0.000;	
	float 	moodRDay = 0.705;	
	float 	moodGDay = 0.58;	
	float 	moodBDay = 0.65;	
	float 	ContrastDay = 0.095;	                        //0.085
	float 	ExposureDay = 0.03485;				//0.035			

	float	EToneMappingOversaturationV7Day = 0.25;


//NIGHT SETTINGS ////////////////////////////////
	float	EBrightnessV7Night=1.0;
	float	EAdaptationMinV7Night=0.16;
	float	EAdaptationMaxV7Night=0.29;
	float 	EToneMappingCurveV7Night=5.0;
	float 	EIntensityContrastV7Night=2.325;
	
//APPLYGAMECOLORCORRECTION is OFF (//)	
	#ifndef APPLYGAMECOLORCORRECTION
	float	EColorSaturationV7Night = 2.15; 
	float 	HCompensateSatV7Night = 1.1; 
#else
//APPLYGAMECOLORCORRECTION is ON	
	float	EColorSaturationV7Night = 2.15; 
	float 	HCompensateSatV7Night =1.1; 	
#endif	

//Mood Colouring Night
	float	fRatioNight = 0.29;						
	float 	moodRNight = 0.805;	
	float 	moodGNight = 0.57;	
	float 	moodBNight = 0.65;	
	float 	ContrastNight = 0.1;	
	float 	ExposureNight = 0.05;

	float	EToneMappingOversaturationV7Night = 0.27;		


//INTERIOR SETTINGS ////////////////////////////////
	float	EBrightnessV7Interior=1.0;
	float	EAdaptationMinV7Interior=0.16;
	float	EAdaptationMaxV7Interior=0.29;
	float 	EToneMappingCurveV7Interior=4.4;                //5.0
	float 	EIntensityContrastV7Interior=2.4485;		//2.450
	
//APPLYGAMECOLORCORRECTION is OFF (//)	
	#ifndef APPLYGAMECOLORCORRECTION
	float	EColorSaturationV7Interior = 2.2; 
	float 	HCompensateSatV7Interior = 1.1;  	
#else
//APPLYGAMECOLORCORRECTION is ON	
	float	EColorSaturationV7Interior = 2.2; 
	float 	HCompensateSatV7Interior =1.1; 
#endif

//Mood Colouring Interior
	float	fRatioInterior = 0.24;					
	float 	moodRInterior = 0.725;	
	float 	moodGInterior = 0.57;	
	float 	moodBInterior = 0.65;	
	float 	ContrastInterior = 0.1;	
	float 	ExposureInterior = 0.05;

	float	EToneMappingOversaturationV7Interior = 0.26;		

#endif
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// KYO : EXTERNAL PARAMETERS BEGINS HERE, SHOULD NOT BE MODIFIED UNLESS YOU KNOW WHAT YOU ARE DOING!!!
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	texture2D texs0; // color
	texture2D texs1; // bloom skyrim
	texture2D texs2; // adaptation skyrim
	texture2D texs3; // bloom enb
	texture2D texs4; // adaptation enb
	texture2D texs7; // palette enb

sampler2D _s0 = sampler_state {
	Texture   = <texs0>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE; // LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s1 = sampler_state {
	Texture   = <texs1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE; // LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s2 = sampler_state {
	Texture   = <texs2>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE; // LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s3 = sampler_state {
	Texture   = <texs3>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE; // LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s4 = sampler_state {
	Texture   = <texs4>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE; // LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s7 = sampler_state {
	Texture   = <texs7>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

struct VS_OUTPUT_POST {
	float4 vpos  	: POSITION;
	float2 txcoord0 : TEXCOORD0;
};

struct VS_INPUT_POST {
	float3 pos 		: POSITION;
	float2 txcoord0 : TEXCOORD0;
};

VS_OUTPUT_POST VS_Quad(VS_INPUT_POST IN){
	VS_OUTPUT_POST OUT;
	OUT.vpos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);
	OUT.txcoord0.xy=IN.txcoord0.xy;
	return OUT;
};

//skyrim shader specific externals, do not modify
	float4 _c1 : register(c1); float4 _c2 : register(c2); float4 _c3 : register(c3);
	float4 _c4 : register(c4); float4 _c5 : register(c5);

float4 PS_D6EC7DD1(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR {
	float4 _oC0 = 0.0; // output
	float4 _c6 = float4(0, 0, 0, 0);
	float4 _c7 = float4(0.212500006, 0.715399981, 0.0720999986, 1.0);
	float4 r0; float4 r1; float4 r2; float4 r3; float4 r4; float4 r5; float4 r6;
	float4 r7; float4 r8; float4 r9; float4 r10; float4 r11; float4 _v0=0.0; 

	#ifdef ENABLE_LETTERBOX_BARS
	
		float LBInteriorFactor = EInteriorFactor;
		float LBNightDayFactor = ENightDayFactor;
		#ifdef ENABLE_FLIP_INT_EXT_FACTOR
			LBInteriorFactor = 1 - EInteriorFactor;
		#endif
		#ifdef ENABLE_FLIP_NITE_DAY_FACTOR
			LBNightDayFactor = 1 - ENightDayFactor;
		#endif
		
		float fLetterboxBarHeight =lerp( lerp( fLetterboxBarHeightDay, fLetterboxBarHeightNight, LBNightDayFactor ), fLetterboxBarHeightInterior, LBInteriorFactor );
	
	if( IN.txcoord0.y > 1.0 - fLetterboxBarHeight || IN.txcoord0.y  < fLetterboxBarHeight )
	{
		return _c6;
	}
	#endif

	_v0.xy = IN.txcoord0.xy;
    r1=tex2D(_s0, _v0.xy); // color
	r11=r1; // my bypass
	_oC0.xyz=r1.xyz; // for future use without game color corrections
	
	// HD6 - You can play with the night/day value here, not that it's advisable to :-D
	// Visualize this with 'debug triangle' further down
	float hnd = ENightDayFactor;
	float ji = EInteriorFactor;
	
		#ifdef ENABLE_FLIP_INT_EXT_FACTOR
		ji = 1 - EInteriorFactor;
		#endif
		
		#ifdef ENABLE_FLIP_NITE_DAY_FACTOR
		hnd = 1 - ENightDayFactor;
		#endif
	
	float2 hndtweak = float2( 3.1 , 1.5 );
	float vhnd = hnd; // effects vignette stregth;
	float bchnd = hnd; // effects hd6 bloom crisp
	float cdhnd = hnd; // effects hd6 colorsat daynight
	
	// Some caves are seen as daytime, so I set key 3 to force nightime
	// This doesnt work very well >_<
	hnd = tempF1.z < 1 ? 0 : hnd;
	hndtweak.x = tempF1.z < 1 ? hndtweak.y : hndtweak.x; // Don't ask, I have no idea why I need this // KYO : Me neither :P
	
	
	// HD6 - Alter Brightness using keyboard during gameplay
		
		float4 tuctbrt1 = uctbrt1;
		float4 tuctbrt2 = uctbrt2;
		float4 tuctcon  = uctcon;
		float4 tuctsat  = uctsat;
		
		#ifdef HD6_DARKER_NIGHTS
			tuctbrt1 -= darkenby1;
		#endif
				
		float h1 = lerp(-1,1,tempF1.x); // Increases speed it changes by when pressing key		
		h1 = lerp( h1, 1, hnd ); // Removes affect during day		
		h1 = h1 - (h1 % 0.1); // Changes it so increments are in steps, remove this if you want smooth changes when pressing keys
		//float hbs = EBloomAmount;
		float hbs = lerp( EBloomAmount/2, EBloomAmount, h1); // Reduce bloom as it gets darker, otherwise it just gets hazier, higher number reduces bloom more as it gets darker
		
		float h2 = lerp(-1,1,tempF1.y); // Increases speed it changes by when pressing key
		h2 = lerp( 1, h2, hnd ); // Removes affect during night
		h2 = h2 - (h2 % 0.1); // Changes it so increments are in steps, remove this if you want smooth changes when pressing keys
		hbs = lerp( (hbs/2)-1, hbs, h2); // Reduce bloom as it gets darker, otherwise it just gets hazier, higher number reduces bloom more as it gets darker
		hbs = max(0,hbs);
		hbs = min(2,hbs); // should be able to go above 1, but not 2
		
		vhnd = lerp(-2,hnd,h2);
		vhnd = max(0,vhnd); // do not go below 0;
		vhnd = min(1,vhnd); // not above 1, just incase people like surface of sun

		cdhnd=bchnd=vhnd;
		//cdhnd=0;
		//bchnd=0;
		//vhnd=0;
		
		#ifdef HD6_COLOR_TWEAKS
			//float2 uctbrt1t = 	float2( lerp( tuctbrt1.x, 	tuctbrt1.y, h1), tuctbrt1.z );
			//float2 uctbrt2t = 	float2( lerp( tuctbrt2.x, 	tuctbrt2.y,	h1), tuctbrt2.y );			
			//float2 uctcont  =	float2( lerp( tuctcon.x, 	tuctcon.y, 	h1), tuctcon.z );
			//float2 uctsatt  =	float2( lerp( tuctsat.x, 	tuctsat.y, 	h1), tuctsat.z );
			float2 uctbrt1t = 	float2( lerp( tuctbrt1.x, 	tuctbrt1.z, h1), lerp( tuctbrt1.y, 	tuctbrt1.w, h2) );
			float2 uctbrt2t = 	float2( lerp( tuctbrt2.x, 	tuctbrt2.z,	h1), lerp( tuctbrt2.y, 	tuctbrt2.w, h2) );			
			float2 uctcont  =	float2( lerp( tuctcon.x, 	tuctcon.z, 	h1), lerp( tuctcon.y, 	tuctcon.w, h2) );
			float2 uctsatt  =	float2( lerp( tuctsat.x, 	tuctsat.z, 	h1), lerp( tuctsat.y, 	tuctsat.w, h2) );
		#endif

	#ifdef APPLYGAMECOLORCORRECTION
		//apply original
		r0.x=1.0/_c2.y;
		r1=tex2D(_s2, _v0);

		//r1.xyz = lerp( 0.28, 0.5, hnd ); // HD6 - disable vanilla adaptation... because it drives me CRAAAZY!!!!! >_<
		//r1.xyz+=1.0;
		r1.xyz = lerp( min( 0.28, r1.xyz ), 0.5, hnd ); // Ligthen if dark, but do not darken if too light, we do this elsewhere for extremely bright situations
		// No seriously it screws up when looking at bright lights at night and the sky during day

		r0.yz=r1.xy * _c1.y;
		r0.w=1.0/r0.y;
		r0.z=r0.w * r0.z;
		r1=tex2D(_s0, _v0);
		r1.xyz=r1 * _c1.y;
		r0.w=dot(_c7.xyz, r1.xyz);
		r1.w=r0.w * r0.z;
		r0.z=r0.z * r0.w + _c7.w;
		r0.z=1.0/r0.z;
		r0.x=r1.w * r0.x + _c7.w;
		r0.x=r0.x * r1.w;
		r0.x=r0.z * r0.x;
		if (r0.w<0) r0.x=_c6.x;
		r0.z=1.0/r0.w;
		r0.z=r0.z * r0.x;
		r0.x=saturate(-r0.x + _c2.x);
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		//r2=tex2D(_s3, _v0); // enb bloom
		r2=tex2D(_s1, _v0);//skyrim bloom

		r2.xyz=0.0; // Screw it bloom should not happen here at all so just set to 0
/**
 *	[KYO : If using original color correction, you can darken blacks a bit by setting the value below to a lower value (e.g. 0.05 or lower)]
 *	[KYO : Helps in adding kind of volume to contours and emulate kind of "AO" on immediate range. Indeed, it makes blacks stronger and tighter]
 *	[KYO : also compensates for unwanted sharpening effects drawbacks, such as "drying" outlines]
 */
	r2 += 0.03475; // HD6 - I add 0.1 to lighten it a bit //[KYO : 0.035 ALMOST IT / 0.05 TOO CLEAR / 0.1 BASE / 0.03 GOOD but lost details / 0.04 AVERAGE but too clear]
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		r2.xyz=r2 * _c1.y;
		r2.xyz=r0.x * r2;
		r1.xyz=r1 * r0.z + r2;
		r0.x=dot(r1.xyz, _c7.xyz);
		r1.w=_c7.w;
		r2=lerp(r0.x, r1, _c3.x);
		r1=r0.x * _c4 - r2;
		r1=_c4.w * r1 + r2;
		r1=_c3.w * r1 - r0.y; // khajiit night vision _c3.w
		r0=_c3.z * r1 + r0.y;
		r1=-r0 + _c5;
		_oC0=_c5.w * r1 + r0;
		//_oC0=r0;
	#endif // APPLYGAMECOLORCORRECTION

	float4 color=_oC0;		
	
	//HD6 brighten when not using original gamma, so they are at least similiar
	//Bloom is diminished for some reason, oh well, I don't use this
/**
#ifndef APPLYGAMECOLORCORRECTION
	color *= 1.45;
	color += 0.03475; //0.02; //0.05
*/
//[KYO : If not using original color correction, you can darken blacks a bit by setting the value above to a lower value (e.g. lower than 0.05)]

	#ifndef APPLYGAMECOLORCORRECTION
		color*=1.45;	//1.2;
		color+=0.02;	//0.03475;	//0.1;			
	#endif
	
	#ifdef COLOR_FILTER
		float CFInteriorFactor = EInteriorFactor;
		float CFNightDayFactor = ENightDayFactor;
		#ifdef ENABLE_FLIP_INT_EXT_FACTOR
			CFInteriorFactor = 1 - EInteriorFactor;
		#endif
		#ifdef ENABLE_FLIP_NIGHT_DAY_FACTOR
			CFNightDayFactor = 1 - ENightDayFactor;
		#endif

		float3 EColorFilter =lerp( lerp( EColorFilterDay, EColorFilterNight, CFNightDayFactor ), EColorFilterInterior, CFInteriorFactor );

		#ifdef COLOR_WHEEL
			EColorFilter.r*= lerp( lerp( MAGENTADay, MAGENTANight, CFNightDayFactor ), MAGENTAInterior, CFInteriorFactor );
			EColorFilter.b*= lerp( lerp( CYANDay, CYANNight, CFNightDayFactor ), CYANInterior, CFInteriorFactor );
			EColorFilter.r*= lerp( lerp( YELLOWDay, YELLOWNight, CFNightDayFactor ), YELLOWInterior, CFInteriorFactor );

			EColorFilter.b*=  lerp( lerp( MAGENTADay, MAGENTANight, CFNightDayFactor ), MAGENTAInterior, CFInteriorFactor );
			EColorFilter.g*= lerp( lerp( CYANDay, CYANNight, CFNightDayFactor ), CYANInterior, CFInteriorFactor );
			EColorFilter.g*= lerp( lerp( YELLOWDay, YELLOWNight, CFNightDayFactor ), YELLOWInterior, CFInteriorFactor );

			EColorFilter.r-= lerp( lerp( MAGENTAsubDay, MAGENTAsubNight, CFNightDayFactor ), MAGENTAsubInterior, CFInteriorFactor );
			EColorFilter.b-= lerp( lerp( CYANsubDay, CYANsubNight, CFNightDayFactor ), CYANsubInterior, CFInteriorFactor );
			EColorFilter.r-= lerp( lerp( YELLOWsubDay, YELLOWsubNight, CFNightDayFactor ), YELLOWsubInterior, CFInteriorFactor );

			EColorFilter.b-=  lerp( lerp( MAGENTAsubDay, MAGENTAsubNight, CFNightDayFactor ), MAGENTAsubInterior, CFInteriorFactor );
			EColorFilter.g-= lerp( lerp( CYANsubDay, CYANsubNight, CFNightDayFactor ), CYANsubInterior, CFInteriorFactor );
			EColorFilter.g-= lerp( lerp( YELLOWsubDay, YELLOWsubNight, CFNightDayFactor ), YELLOWsubInterior, CFInteriorFactor );
		#endif
		
		color.xyz*=EColorFilter;
	#endif

	#ifdef HD6_COLORSAT_DAYNIGHT

		float3 nsatn= lerp( dnsati, ( lerp( dnsatn, dnsatd, hnd ) ), ji );
		float3 oldcoln = color.xyz;
		color.xyz *=nsatn;
//+++++++Changes appareance of colors, bloom color perception handled elsewhere+++++++++++++++++++++++++++++++++++++++++++++++
		//float3 greycn = float3(0.299, 0.587, 0.114); // perception of color luminance
		//float3 greycn = float3(0.811,0.523,0.996);// perception of color luminance
		float3 greycn = float3(0.333,0.333,0.333); // screw perception
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		color.xyz += (oldcoln.x-(oldcoln.x*nsatn.x)) * greycn.x;
		color.xyz += (oldcoln.y-(oldcoln.y*nsatn.y)) * greycn.y;
		color.xyz += (oldcoln.z-(oldcoln.z*nsatn.z)) * greycn.z;
	#endif
	
/*
	#ifndef APPLYGAMECOLORCORRECTION
		//temporary fix for khajiit night vision, but it also degrade colors.
		//	r1=tex2D(_s2, _v0);
		//	r0.y=r1.xy * _c1.y;
		r1=_oC0;
		r1.xyz=r1 * _c1.y;
		r0.x=dot(r1.xyz, _c7.xyz);
		r2=lerp(r0.x, r1, _c3.x);
		r1=r0.x * _c4 - r2;
		r1=_c4.w * r1 + r2;
		r1=_c3.w * r1;// - r0.y;
		r0=_c3.z * r1;// + r0.y;
		r1=-r0 + _c5;
		_oC0=_c5.w * r1 + r0;
	#endif //!APPLYGAMECOLORCORRECTION
*/

	//adaptation in time
	float4	Adaptation=tex2D(_s4, 0.5);
	float	grayadaptation=max(max(Adaptation.x, Adaptation.y), Adaptation.z);
	//grayadaptation=1.0/grayadaptation;

	#ifdef COMBINE_BLOOM
		float4	xcolorbloom = tex2D(_s3, _v0.xy) + tex2D(_s1, _v0.xy);
	#else
		float4	xcolorbloom = tex2D(_s3, _v0.xy);
	#endif
	
	//xcolorbloom.xyz=0.2; //HDebug
	//float	maxb=max(xcolorbloom.x, max(xcolorbloom.y, xcolorbloom.z));
	//float	violetamount=maxb/(maxb+EVioletShiftAmountInv);
	//xcolorbloom.xyz=lerp(xcolorbloom.xyz, xcolorbloom.xyz*EVioletShiftColor, violetamount*violetamount);

	#ifdef HD6_BLOOM_DEBLUEIFY

		//New saturation to be // 0 being no color
				//float3 nsat=float3(1,0.74,0.64); 	// perfect-ish - removes blue and green from fog and outdoors, makes dwarven ruins very white though
				//float3 nsat=float3(1,0.80,0.74); 	// Touch greener 
				//float3 nsat=float3(1,0.70,0.65); 	// Grey, very grey ice gaves almost white, but... foggy days go pink
				//float3 nsat=float3(0.85,0.75,0.7); 	// More reasonable, still pink sky and snow in places
				//float3 nsat=float3(0.80,0.75,0.73);
				//float3 nsat=float3(1,0.64,0.58);
				//float3 nsat=float3(1,0.74,0.90);	
				//float3 nsat=float3(0.8,0.56,0.46);
				//float3 nsat=float3(0.7,0.6,0.4); 	// desatures everything a bit
				//float3 nsat=float3(0,0,0); 		// no color in bloom, makes everything very desaturated, fire looks white almost

		// --JawZ-- added day, night and interior debluify	// KYO : Bingo !
			float3 nsat= lerp( bsati, ( lerp( bsatn, bsatd, hnd ) ), ji );

		// store old values
			float3 oldcol=xcolorbloom.xyz;
			
		// adjust saturation
			xcolorbloom.xyz *= nsat;

//+++++++Changes appareance of color perception for Bloom only++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				//float3 greyc = float3(0.299, 0.587, 0.114); // perception of color luminance
				//float3 greyc = float3(0.811,0.523,0.996; // perception of color luminance
				float3 greyc = float3(0.333,0.333,0.333); // screw perception
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

			xcolorbloom.xyz += (oldcol.x-(oldcol.x*nsat.x)) * greyc.x;
			xcolorbloom.xyz += (oldcol.y-(oldcol.y*nsat.y)) * greyc.y;
			xcolorbloom.xyz += (oldcol.z-(oldcol.z*nsat.z)) * greyc.z;

		// equiv to bloom off without destroyng scene luminance-ish
		//xcolorbloom.x=0.3;
		//xcolorbloom.y=0.3;
		//xcolorbloom.z=0.3;

		//xcolorbloom.xyz=min(xcolorbloom.xyz,1.2);
	#endif

	#ifdef HD6_COLOR_TWEAKS

		#ifdef HD6_COLOR_TWEAKS_DNI
			float ctbrt1 = lerp( lerp( uctbrt1t.x, uctbrt1t.y, hnd),uctbrt1.z, ji); // Brightness Night, Day (Alters before contrast adjustment)
			float ctbrt2 = lerp( lerp( uctbrt2t.x, uctbrt2t.y, hnd),uctbrt2.z, ji); // Brightness Night, Day (Alters after contrast adjustment)
			float ctcon =  lerp( lerp( uctcont.x, uctcont.y, hnd),uctcon.z, ji);    // Contrast Night, Day
			float ctsat =  lerp( lerp( uctsatt.x, uctsatt.y, hnd),uctsat.z, ji);    // Saturation Night, Day
		#else
			float ctbrt1 = lerp(uctbrt1t.x,uctbrt1t.y,hnd); // Brightness Night, Day (Alters before contrast adjustment)
			float ctbrt2 = lerp(uctbrt2t.x,uctbrt2t.y,hnd); // Brightness Night, Day (Alters after contrast adjustment)
			float ctcon = lerp(uctcont.x,uctcont.y,hnd); // Contrast Night, Day
			float ctsat = lerp(uctsatt.x,uctsatt.y,hnd); // Saturation Night, Day
		#endif

		float3 ctLumCoeff = float3(0.2125, 0.7154, 0.0721);				
		float3 ctAvgLumin = float3(0.5, 0.5, 0.5);
		float3 ctbrtColor = color.rgb * ctbrt1;

		float3 ctintensity = dot(ctbrtColor, ctLumCoeff);
		float3 ctsatColor = lerp(ctintensity, ctbrtColor, ctsat); 
		float3 cconColor = lerp(ctAvgLumin, ctsatColor, ctcon);

		color.xyz = cconColor * ctbrt2;
		float3 cbalance = lerp(rgbi, ( lerp (rgbn,rgbd, hnd) ), ji);
		color.xyz = cbalance.xyz * color.xyz;

	#endif
	
	
	#ifdef USEBLOOM

	#ifdef BLOOM_COLORIZATION

			xcolorbloom.r*= lerp( REDbloommultInterior, ( lerp( REDbloommultNight, REDbloommultDay, hnd ) ), ji);
			xcolorbloom.g*= lerp( GREENbloommultInterior, ( lerp( GREENbloommultNight, GREENbloommultDay, hnd ) ), ji);
			xcolorbloom.b*= lerp( BLUEbloommultInterior, ( lerp( BLUEbloommultNight, BLUEbloommultDay, hnd ) ), ji);

			xcolorbloom.r*= lerp( MAGENTAbloomInterior, ( lerp( MAGENTAbloomNight, MAGENTAbloomDay, hnd ) ), ji);
			xcolorbloom.b*= lerp( MAGENTAbloomInterior, ( lerp( MAGENTAbloomNight, MAGENTAbloomDay, hnd ) ), ji);

			xcolorbloom.g*= lerp( CYANbloomInterior, ( lerp( CYANbloomNight, CYANbloomDay, hnd ) ), ji);
			xcolorbloom.b*= lerp( CYANbloomInterior, ( lerp( CYANbloomNight, CYANbloomDay, hnd ) ), ji);

			xcolorbloom.r*= lerp( YELLOWbloomInterior, ( lerp( YELLOWbloomNight, YELLOWbloomDay, hnd ) ), ji);
			xcolorbloom.g*= lerp( YELLOWbloomInterior, ( lerp( YELLOWbloomNight, YELLOWbloomDay, hnd ) ), ji);

			xcolorbloom.r-= lerp( REDbloomsubInterior, ( lerp( REDbloomsubNight, REDbloomsubDay, hnd ) ), ji);
			xcolorbloom.g-= lerp( GREENbloomsubInterior, ( lerp( GREENbloomsubNight, GREENbloomsubDay, hnd ) ), ji);
			xcolorbloom.b-= lerp( BLUEbloomsubInterior, ( lerp( BLUEbloomsubNight, BLUEbloomsubDay, hnd ) ), ji);

		color.xyz+=xcolorbloom.xyz*EBloomAmount;
	#endif

		#ifdef DIFFUSE_BLOOM
			xcolorbloom.r*= lerp( REDInterior, ( lerp( REDNight, REDDay, hnd ) ), ji);
			xcolorbloom.g*= lerp( GREENInterior, ( lerp( GREENNight, GREENDay, hnd ) ), ji);
			xcolorbloom.b*= lerp( BLUEInterior, ( lerp( BLUENight, BLUEDay, hnd ) ), ji);
			
			float Saturation = lerp( SatInterior, ( lerp( SatNight, SatDay, hnd ) ), ji);
			float Luma = lerp( LumaInterior, ( lerp( LumaNight, LumaDay, hnd ) ), ji );
			float Pow = lerp( PowInterior, ( lerp( PowNight, PowDay, hnd ) ), ji );
			float Pow2 = lerp( Pow2Interior, ( lerp( Pow2Night, Pow2Day, hnd ) ), ji );

			float3 cgray2=dot(xcolorbloom.xyz, Luma);
			float3 poweredcolor2=pow(xcolorbloom.xyz, Saturation);
			float newgray2=dot(poweredcolor2.xyz, Pow);
			xcolorbloom.xyz=poweredcolor2.xyz*cgray2/(newgray2+Pow2);

			color.xyz+=xcolorbloom.xyz*EBloomAmount;
		#endif

		#ifdef HD6_BLOOM_NOBLACK

			float lowestvalue=min(min(xcolorbloom.x,xcolorbloom.y),xcolorbloom.z);
			// work out lowest possible value to set RGB without going below 0 and without changing the RGB relative values ie shifting the color in the process
			float3 lowestpossible=xcolorbloom.xyz-lowestvalue;
			xcolorbloom.xyz=max(xcolorbloom.xyz,lowestpossible+(0.12*(1-hnd))); // adds 0.1 during night only

	#else

		#ifdef HD6_BLOOM_DEFUZZ
			// Heliosdouble cobbled together bloom defuzzer - increases contrast of bloom / stop it hazing low brightness values

			float mavg=((xcolorbloom.x+xcolorbloom.y+xcolorbloom.z)*0.333);
			xcolorbloom.xyz-=(mavg*0.3);
			//xcolorbloom.xyz=min(xcolorbloom.xyz,0.0);
			xcolorbloom.xyz+=(mavg*0.22);
			xcolorbloom.xyz*(mavg*1.2);

	#else

		#ifdef HD6_BLOOM_CRISP	
			float3 LumCoeff = lerp( LumCoeffInterior, ( lerp( LumCoeffNight, LumCoeffDay,  bchnd ) ), ji);			
			float3 AvgLumin = lerp( AvgLuminInterior, ( lerp( AvgLuminNight, AvgLuminDay,  bchnd ) ), ji);	

		//color*=1.02;	//1.04	//1.06
		//color*=1.0; // Brighten it up without loosing contrast
		//color += lerp(0.1,0.1,bchnd); // Night, Day, increase kinda lowers contrast, but makes things look more washed out also, this is to lift black areas really
		//color+=((color/2)*EBloomAmount);
		//xcolorbloom-=0.05; //[NOTE - Enable this to darken bloom overall]
		//xcolorbloom=max(xcolorbloom,0); // will cause color shift/desaturation also
		//color.xyz+=(color.xyz*(xcolorbloom*EBloomAmount*0.2))+(xcolorbloom/1.5);
		//color.xyz=(color.xyz*color.xyz)/2;			
		//color.xyz=(color.xyz*0.5)+((color.xyz*(xcolorbloom*EBloomAmount))*0.5);
		//color.xyz*=0.8;		
		//color.xyz*=1.4;	

			// Limits what triggers a bloom
			float3 brightbloom = xcolorbloom - lerp( TrigInterior, ( lerp( TrigNight, TrigDay,  bchnd ) ), ji);
				brightbloom = max( brightbloom , 0);

			// Limits bloom to superbright spots only
			float3 superbright = xcolorbloom - lerp( SBrightInterior, ( lerp( SBrightNight, SBrightDay,  bchnd ) ), ji);
				superbright = max( superbright , 0 ) ; // crop so dont go any lower than black
				//superbright = lerp( AvgLumin, superbright, 0.5); // Contrast
				superbright *= 0.6;		
			
			// Bloom - Brightness, Contrast and Saturation
			float3 brt = lerp( CBrightnessInterior, ( lerp( CBrightnessNight, CBrightnessDay,   bchnd ) ), ji);
			float3 con = lerp( CContrastInterior, ( lerp( CContrastNight, CContrastDay,   bchnd ) ), ji);
			float3 sat = lerp( CSaturationInterior, ( lerp( CSaturationNight, CSaturationDay,   bchnd ) ), ji);
				float3 brtColor = brightbloom * brt;
				float3 cintensity = dot( brtColor, LumCoeff );
				float3 satColor = lerp( cintensity, brtColor, sat ); 
				float3 conColor = lerp( AvgLumin, satColor, con );
				conColor -= 0.3;
				brightbloom = conColor;

			// These values compensates the brightness when no bloom is used
			color.xyz +=  lerp( BrightnessModInterior, ( lerp( BrightnessModNight, BrightnessModDay, bchnd ) ), ji);
			color.xyz *= lerp( BrightnessMultInterior, ( lerp( BrightnessMultNight, BrightnessMultDay, bchnd ) ), ji);

			// Adds bloom while compensating for any brightness change
			color.xyz += (( superbright * hbs ) * lerp( CompSBInterior, ( lerp( CompSBNight, CompSBDay,  bchnd ) ), ji)); // Limits where the bloom will "bloom"
			brightbloom -= ( superbright * 2 ); // removes superbright from brightbloom
			brightbloom = max( brightbloom , 0.0 );
			color.xyz += (( brightbloom * hbs ) * lerp( BloomStrInterior, ( lerp( BloomStrNight, BloomStrDay,  bchnd ) ), ji)); // How strong the bloom will be

			// This blends the the ENB and Skyrim bloom together, for a more hazey effect
			color.xyz += (xcolorbloom.xyz * hbs) * lerp( BloomBlendInterior, ( lerp( BloomBlendNight, BloomBlendDay,  bchnd ) ), ji); // How much the blend there will be
			color.xyz *= lerp( BlendCompInterior, ( lerp( BlendCompNight, BlendCompDay,  bchnd ) ), ji); // compensate for brightening caused by above bloom

		#else

			#ifdef HD6_BLOOM_SCREEN
				// Helios code to restrict bloom to bright areas only, not smudging dark outs around

				color+=((color/1)*EBloomAmount); // compensate if bloom disabled	
				xcolorbloom=max(xcolorbloom,0); // will cause color shift/desaturation also
				float tmult = 10;
				color/=tmult; xcolorbloom/=tmult; // Screen mode wont work with floating point numbers / big numbers, so I reduce it first

				color.x = 1.0 - ((1.0 - color.x) * (1.0 - xcolorbloom.x));
				color.y = 1.0 - ((1.0 - color.y) * (1.0 - xcolorbloom.y));
				color.z = 1.0 - ((1.0 - color.z) * (1.0 - xcolorbloom.z));
				color*=tmult;

			#else
				float tt=1;
				//float3 tt = float3(1*tempF1.x,1*tempF1.x,1*tempF1.x);
				color.xyz+=((xcolorbloom.xyz*EBloomAmount)*tt);
			#endif 	
		   #endif
	      #endif
	     #endif

		#else
			// No bloom
			color+=((color/1)*EBloomAmount); // compensate if bloom disabled
		#endif
		
	//+++++++++++++++++++++++++++++
		
	#ifdef HD6_VIGNETTE		
		// yes this is my own crazy creation after seing how boring the usual linear circle vignettes typically are
		// no doubt I have done it in an overly convoluted way :-)
		
		//float fExposureLevel = 1.0; // compensate for any change from vignette so center is same brightness
		float2 inTex = _v0;	
		float4 voriginal = r1;
		float4 vcolor = voriginal;
		vcolor.xyz=1;
		inTex -= 0.5; // Centers vignette
		inTex.y += 0.01; // Move it off center and up so it obscures sky less
		float vignette = 1.0 - dot( inTex, inTex );
		vcolor *= pow( vignette, vignettepow );
		
		
		// Round Vignette
		float4 rvigtex = vcolor;
		rvigtex.xyz = pow( vcolor, 1 );
		rvigtex.xyz = lerp(float3(0.5, 0.5, 0.5), rvigtex.xyz, 2.0); // Increase Contrast
		rvigtex.xyz = lerp(float3(1,1,1),rvigtex.xyz,rovigpwr); // Set strength of round vignette
		
		// Square Vignette (just top and bottom of screen)
		float4 vigtex = vcolor;
		vcolor.xyz = float3(1,1,1);
		float3 topv = min((inTex.y+0.5)*2,0.5) * 2; // Top vignette
		float3 botv = min(((0-inTex.y)+0.5)*2,0.5) * 2; // Bottom vignette
		
		topv= lerp(float3(1,1,1), topv, sqvigpwr.x);
		botv= lerp(float3(1,1,1), botv, sqvigpwr.y);
		vigtex.xyz = (topv)*(botv);
		
		//vigtex.xyz = lerp(float3(1,1,1),vigtex.xyz,sqvigpwr); // Set strength of square vignette
				
		// Add round and square together
		vigtex.xyz*=rvigtex.xyz; 
		
		vigtex.xyz = lerp(vigtex.xyz,float3(1,1,1),(1-vstrengthatnight)*(1-vhnd)); // Alter Strength at night
		
			vigtex.xyz = min(vigtex.xyz,1);
			vigtex.xyz = max(vigtex.xyz,0);
			//vigtex.xyz -= 0.5;
			//(base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))
			//vigtex.xyz = vigtex.xyz < 0.5 ? (2.0 * color.xyz * vigtex.xyz) : (1 - 2 * (1 - color.xyz) * (1 - vigtex.xyz));
			// Crap I keep forgetting overlay mode doesnt work in floating point/32bit/hdr dur bee durr
				
		// Increase saturation where edges were darkenned
		float3 vtintensity = dot(color.xyz, float3(0.2125, 0.7154, 0.0721));
		color.xyz = lerp(vtintensity, color.xyz, ((((1-(vigtex.xyz*2))+2)-1)*vsatstrength)+1  );
		
			//color.xyz+=0.02;
		color.xyz *= (vigtex.xyz);
			//color.xyz *= fExposureLevel;	
		
	#endif
	
	// HD6 - Warning, Code below appears to reduce 'color.xyz' to 8bit / LDR

//+++++++This controls HD6 own adptaion strength/intensity+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// HD6 - Warning, Code below appears to reduce 'color.xyz' to 8bit / LDR				
	// HD6 - Eye Adaptation for extreme extremely over bright areas only
	// 0.3, 0.9 - affects day time sunny day = bad
	// [KYO - Adaptation settings] Thanx MIDH !
	float toobright = max(0,tex2D(_s2, _v0).xyz - 0.63); // 0.1 = DARK 0.35 = normal light, 0.5 = bright
	color.xyz *= 1-(1 * toobright); // 1.3
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	#ifdef HD6_PALETTE_MIXER
		// <Lazy> HD6 - dopey arse code to alter enbpalette because im too lazy to open photoshop
		// when using your own palette remove this.. ill fix this.. next

		float palmix = lerp( palmixInterior, ( lerp( palmixNight, palmixDay, hnd ) ), ji );
	#else
		float palmix = 0.5;
	#endif
//+++++++This controls how strong the enbpalette.bmp will be++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		color.xyz*= lerp( 1.0, 1.0, palmix);	//0.9	//1.1

	float s1 = lerp(-1,1,tempF1.w); // Increases speed it changes by when pressing key		
	s1 = s1 - (s1 % 0.1);
	
	float3 sat1 = float3(0,0,0);
	float3 sat2 = float3(1,1,1);
	
	float3 snsat = lerp(sat1,sat2,s1);
	// store old values
		float3 soldcol=color.xyz;
		
	// adjust saturation
		color.xyz *= snsat;
		
	// spread lost luminance over everything
			//float3 sgreyc = float3(0.299, 0.587, 0.114); // perception of color luminace
		float3 sgreyc = float3(0.333,0.333,0.333); // screw perception
		color.xyz += (soldcol.x-(soldcol.x*snsat.x)) * sgreyc.x;
		color.xyz += (soldcol.y-(soldcol.y*snsat.y)) * sgreyc.y;
		color.xyz += (soldcol.z-(soldcol.z*snsat.z)) * sgreyc.z;
		
		
	//+++++++++++++++++++++++++++++
	#if (POSTPROCESS==1)

	float EAdaptationMinV1 = lerp( EAdaptationMinV1Interior, ( lerp( EAdaptationMinV1Night, EAdaptationMinV1Day, hnd ) ), ji );
	float EAdaptationMaxV1 = lerp( EAdaptationMaxV1Interior, ( lerp( EAdaptationMaxV1Night, EAdaptationMaxV1Day, hnd ) ), ji );
	float EContrastV1 = lerp( EContrastV1Interior, ( lerp( EContrastV1Night, EContrastV1Day, hnd ) ), ji );
	float EColorSaturationV1 = lerp( EColorSaturationV1Interior, ( lerp( EColorSaturationV1Night, EColorSaturationV1Day, hnd ) ), ji );
	float EToneMappingCurveV1 = lerp( EToneMappingCurveV1Interior, ( lerp( EToneMappingCurveV1Night, EToneMappingCurveV1Day, hnd ) ), ji );

		grayadaptation=max(grayadaptation, 0.0);
		grayadaptation=min(grayadaptation, 50.0);
		color.xyz=color.xyz/(grayadaptation*EAdaptationMaxV1+EAdaptationMinV1);//*tempF1.x

		float cgray=dot(color.xyz, float3(0.27, 0.67, 0.06));
		cgray=pow(cgray, EContrastV1);
		float3 poweredcolor=pow(color.xyz, EColorSaturationV1);
		float newgray=dot(poweredcolor.xyz, float3(0.27, 0.67, 0.06));
		color.xyz=poweredcolor.xyz*cgray/(newgray+0.0001);

		float3	luma=color.xyz;
		float	lumamax=300.0;
		color.xyz=(color.xyz * (1.0 + color.xyz/lumamax))/(color.xyz + EToneMappingCurveV1);

	#endif
	//+++++++++++++++++++++++++++++

	//+++++++++++++++++++++++++++++
//-/////////////////////////////////////////////////////////////////////////////////////////////////////////
#if (POSTPROCESS==2)

	float newEAdaptationMax = lerp( EAdaptationMaxV2Interior, ( lerp( EAdaptationMaxV2Night, EAdaptationMaxV2Day, hnd ) ), ji );
	float newEAdaptationMin = lerp( EAdaptationMinV2Interior, ( lerp( EAdaptationMinV2Night, EAdaptationMinV2Day, hnd ) ), ji );
	float newEBrightnessV2 = lerp( EBrightnessV2Interior, ( lerp( EBrightnessV2Night, EBrightnessV2Day, hnd ) ), ji );
	float newEToneMappingCurve = lerp( EToneMappingCurveV2Interior, ( lerp( EToneMappingCurveV2Night, EToneMappingCurveV2Day, hnd ) ), ji );
	float newEIntensityContrastV2 = lerp( EIntensityContrastV2Interior, ( lerp( EIntensityContrastV2Night, EIntensityContrastV2Day, hnd ) ), ji );
	float newEToneMappingOversaturationV2 = lerp( EToneMappingOversaturationV2Interior, ( lerp( EToneMappingOversaturationV2Night, EToneMappingOversaturationV2Day, hnd ) ), ji );
	float newEColorSaturationV2 = lerp( EColorSaturationV2Interior, ( lerp( EColorSaturationV2Night, EColorSaturationV2Day, hnd ) ), ji );


		grayadaptation=max(grayadaptation, 0.0);
		grayadaptation=min(grayadaptation, 50.0);
		color.xyz=color.xyz/(grayadaptation*newEAdaptationMax+newEAdaptationMin);//*tempF1.x

		color.xyz*=(newEBrightnessV2);
		color.xyz+=0.000001;
		float3 xncol=normalize(color.xyz);
		float3 scl=color.xyz/xncol.xyz;
		scl=pow(scl, newEIntensityContrastV2);
		xncol.xyz=pow(xncol.xyz, newEColorSaturationV2);
		color.xyz=scl*xncol.xyz;

		float	lumamax=newEToneMappingOversaturationV2;
		color.xyz=(color.xyz * (1.0 + color.xyz/lumamax))/(color.xyz + newEToneMappingCurve);
	
		//Alternative calculation for colour calculation in postprocess 2 (line above)
		//color.xyz=1.1*color.xyz/(color.xyz + newEToneMappingCurve);

		//dpeasant Colour Mood code

	float fRatio = lerp( fRatioInterior, ( lerp( fRatioNight, fRatioDay, hnd ) ), ji );

	float moodR = lerp( moodRInterior, ( lerp( moodRNight, moodRDay, hnd ) ), ji );
	float moodG = lerp( moodGInterior, ( lerp( moodGNight, moodGDay, hnd ) ), ji );
	float moodB = lerp( moodBInterior, ( lerp( moodBNight, moodBDay, hnd ) ), ji );

	float Exposure = lerp( ExposureInterior, ( lerp( ExposureNight, ExposureDay, hnd ) ), ji );
	float Contrast = lerp( ContrastInterior, ( lerp( ContrastNight, ContrastDay, hnd ) ), ji );

		float4 colInput = color;
		float4 colMood = 1.0f;
		colMood.r = moodR;
		colMood.g = moodG;
		colMood.b = moodB;
		float fLum = ( colInput.r + colInput.g + colInput.b ) / 3;

		colMood = lerp(0, colMood, saturate(fLum * 2.0));
		colMood = lerp(colMood, 1, saturate(fLum - 0.5) * 2.0);
		float4 colOutput = lerp(colInput, colMood, saturate(fLum * fRatio));
		color.rgb=max(0, colOutput);
		
		//dpeasant Contrast code
		color.xyz = saturate(color.xyz);
		color.xyz = lerp(color.xyz, 0.5 * (1 + sin((color.xyz - 0.5)*3.1415926)), Contrast);
	
		//dpeasant Exposure code
		color.rgb *= pow(2.0f, Exposure);

#endif

//-/////////////////////////////////////////////////////////////////////////////////////////////////////////
	//+++++++++++++++++++++++++++++

	//+++++++++++++++++++++++++++++
	#if (POSTPROCESS==3)

	float EAdaptationMaxV3 = lerp( EAdaptationMaxV3Interior, ( lerp( EAdaptationMaxV3Night, EAdaptationMaxV3Day, hnd ) ), ji );
	float EAdaptationMinV3 = lerp( EAdaptationMinV3Interior, ( lerp( EAdaptationMinV3Night, EAdaptationMinV3Day, hnd ) ), ji );
	float EToneMappingOversaturationV3 = lerp( EToneMappingOversaturationV3Interior, ( lerp( EToneMappingOversaturationV3Night, EToneMappingOversaturationV3Day, hnd ) ), ji );
	float EToneMappingCurveV3 = lerp( EToneMappingCurveV3Interior, ( lerp( EToneMappingCurveV3Night, EToneMappingCurveV3Day, hnd ) ), ji );


		grayadaptation=max(grayadaptation, 0.0);
		grayadaptation=min(grayadaptation, 50.0);
		color.xyz=color.xyz/(grayadaptation*EAdaptationMaxV3+EAdaptationMinV3);//*tempF1.x

		float	lumamax=EToneMappingOversaturationV3;
		color.xyz=(color.xyz * (1.0 + color.xyz/lumamax))/(color.xyz + EToneMappingCurveV3);

	#endif
	//+++++++++++++++++++++++++++++

	//color.xyz=tex2D(_s0, _v0.xy) + xcolorbloom.xyz*float3(0.7, 0.6, 1.0)*0.5;
	//color.xyz=tex2D(_s0, _v0.xy) + xcolorbloom.xyz*float3(0.7, 0.6, 1.0)*0.5;
	//color.xyz*=0.7;

	//+++++++++++++++++++++++++++++
	#if (POSTPROCESS==4)

	float EAdaptationMaxV4 = lerp( EAdaptationMaxV4Interior, ( lerp( EAdaptationMaxV4Night, EAdaptationMaxV4Day, hnd ) ), ji );
	float EAdaptationMinV4 = lerp( EAdaptationMinV4Interior, ( lerp( EAdaptationMinV4Night, EAdaptationMinV4Day, hnd ) ), ji );
	float EBrightnessCurveV4 = lerp( EBrightnessCurveV4Interior, ( lerp( EBrightnessCurveV4Night, EBrightnessCurveV4Day, hnd ) ), ji );
	float EBrightnessMultiplierV4 = lerp( EBrightnessMultiplierV4Interior, ( lerp( EBrightnessMultiplierV4Night, EBrightnessMultiplierV4Day, hnd ) ), ji );
	float EBrightnessToneMappingCurveV4 = lerp( EBrightnessToneMappingCurveV4Interior, ( lerp( EBrightnessToneMappingCurveV4Night, EBrightnessToneMappingCurveV4Day, hnd ) ), ji );

		grayadaptation=max(grayadaptation, 0.0);
		grayadaptation=min(grayadaptation, 50.0);
		color.xyz=color.xyz/(grayadaptation*EAdaptationMaxV4+EAdaptationMinV4);

		float Y = dot(color.xyz, float3(0.299, 0.587, 0.114)); //0.299 * R + 0.587 * G + 0.114 * B;
		float U = dot(color.xyz, float3(-0.14713, -0.28886, 0.436)); //-0.14713 * R - 0.28886 * G + 0.436 * B;
		float V = dot(color.xyz, float3(0.615, -0.51499, -0.10001)); //0.615 * R - 0.51499 * G - 0.10001 * B;
		Y=pow(Y, EBrightnessCurveV4);
		Y=Y*EBrightnessMultiplierV4;
	//	Y=Y/(Y+EBrightnessToneMappingCurveV4);
	//	float	desaturatefact=saturate(Y*Y*Y*1.7);
	//	U=lerp(U, 0.0, desaturatefact);
	//	V=lerp(V, 0.0, desaturatefact);
		color.xyz=V * float3(1.13983, -0.58060, 0.0) + U * float3(0.0, -0.39465, 2.03211) + Y;

		color.xyz=max(color.xyz, 0.0);
		color.xyz=color.xyz/(color.xyz+EBrightnessToneMappingCurveV4);

	#endif
	//+++++++++++++++++++++++++++++

	//+++++++++++++++++++++++++++++ HD6 version based on postprocess 2
	#if (POSTPROCESS==5)

	float EAdaptationMaxV5 = lerp( EAdaptationMaxV5Interior, ( lerp( EAdaptationMaxV5Night, EAdaptationMaxV5Day, hnd ) ), ji );
	float EAdaptationMinV5 = lerp( EAdaptationMinV5Interior, ( lerp( EAdaptationMinV5Night, EAdaptationMinV5Day, hnd ) ), ji );
	float EIntensityContrastV5 = lerp( EIntensityContrastV5Interior, ( lerp( EIntensityContrastV5Night, EIntensityContrastV5Day, hnd ) ), ji );
	float EColorSaturationV5 = lerp( EColorSaturationV5Interior, ( lerp( EColorSaturationV5Night, EColorSaturationV5Day, hnd ) ), ji );
	float HCompensateSatV5 = lerp( HCompensateSatV5Interior, ( lerp( HCompensateSatV5Night, HCompensateSatV5Day, hnd ) ), ji );
	float EToneMappingCurveV5 = lerp( EToneMappingCurveV5Interior, ( lerp( EToneMappingCurveV5Night, EToneMappingCurveV5Day, hnd ) ), ji );

			grayadaptation=max(grayadaptation, 0.0);
			grayadaptation=min(grayadaptation, 50.0);
			//color.xyz=color.xyz/(grayadaptation*EAdaptationMaxV5+EAdaptationMinV5); //*tempF1.x		
		//color.xyz*=lerp( 3.1, 1.5, hnd );
		color.xyz*=lerp( hndtweak.x, hndtweak.y, hnd );

		//color.xyz*=EBrightnessV5;
		//color.xyz+=0.000001; // HD6 - Why? how curious
		float3 xncol=normalize(color.xyz);
		float3 scl=color.xyz/xncol.xyz;
		scl=pow(scl, EIntensityContrastV5);
		xncol.xyz=pow(xncol.xyz, EColorSaturationV5);
		color.xyz=scl*xncol.xyz;
		color.xyz*=HCompensateSatV5; // compensate for darkening caused my EcolorSat above

			//float	lumamax=EToneMappingOversaturationV5;
			//color.xyz=(color.xyz * (1.0 + color.xyz/lumamax))/(color.xyz + EToneMappingCurveV5);

		color.xyz=color.xyz/(color.xyz + EToneMappingCurveV5);
			//color.xyz=tex2D(_s0, _v0.xy);
			//color.xyz=color.xyz-0.03;
			//color.xyz/=10;
	#endif
//-/////////////////////////////////////////////////////////////////////////////////////////////////////////
#if (POSTPROCESS==6)

	float newEAdaptationMax = lerp( EAdaptationMaxV6Interior, ( lerp( EAdaptationMaxV6Night, EAdaptationMaxV6Day, hnd ) ), ji );
	float newEAdaptationMin = lerp( EAdaptationMinV6Interior, ( lerp( EAdaptationMinV6Night, EAdaptationMinV6Day, hnd ) ), ji );
	float newEBrightnessV6 = lerp( EBrightnessV6Interior, ( lerp( EBrightnessV6Night, EBrightnessV6Day, hnd ) ), ji );
	float newEToneMappingCurve = lerp( EToneMappingCurveV6Interior, ( lerp( EToneMappingCurveV6Night, EToneMappingCurveV6Day, hnd ) ), ji );
	float newEIntensityContrastV6 = lerp( EIntensityContrastV6Interior, ( lerp( EIntensityContrastV6Night, EIntensityContrastV6Day, hnd ) ), ji );
	float newEToneMappingOversaturationV6 = lerp( EToneMappingOversaturationV6Interior, ( lerp( EToneMappingOversaturationV6Night, EToneMappingOversaturationV6Day, hnd ) ), ji );
	float newEColorSaturationV6 = lerp( EColorSaturationV6Interior, ( lerp( EColorSaturationV6Night, EColorSaturationV6Day, hnd ) ), ji );

//	float newEBrightnessCurveV6 = lerp( newEBrightnessCurveV6Interior, ( lerp( newEBrightnessCurveV6Night, newEBrightnessCurveV6Day, ENightDayFactor ) ), EInteriorFactor );
//	float newEBrightnessMultiplierV6 = lerp( newEBrightnessMultiplierV6Interior, ( lerp( newEBrightnessMultiplierV6Night, newEBrightnessMultiplierV6Day, ENightDayFactor ) ), EInteriorFactor );
//	float newEBrightnessToneMappingCurveV6 = lerp( newEBrightnessToneMappingCurveV6Interior, ( lerp( newEBrightnessToneMappingCurveV6Night, newEBrightnessToneMappingCurveV6Day, ENightDayFactor ) ), EInteriorFactor );
	
	grayadaptation=max(grayadaptation, 0.0);
	grayadaptation=min(grayadaptation, 50.0);
	color.xyz=color.xyz/(grayadaptation*newEAdaptationMax+newEAdaptationMin);//*tempF1.x

	color.xyz*=(newEBrightnessV6);
	color.xyz+=0.000001;
	float3 xncol=normalize(color.xyz);
	float3 scl=color.xyz/xncol.xyz;
	scl=pow(scl, newEIntensityContrastV6);
	xncol.xyz=pow(xncol.xyz, newEColorSaturationV6);
	color.xyz=scl*xncol.xyz;

	float	lumamax=newEToneMappingOversaturationV6;
	color.xyz=(color.xyz * (1.0 + color.xyz/lumamax))/(color.xyz + newEToneMappingCurve);
	
//    	float Y = dot(color.xyz, float3(0.299, 0.587, 0.114)); //0.299 * R + 0.587 * G + 0.114 * B;
//	float U = dot(color.xyz, float3(-0.14713, -0.28886, 0.436)); //-0.14713 * R - 0.28886 * G + 0.436 * B;
//	float V = dot(color.xyz, float3(0.615, -0.51499, -0.10001)); //0.615 * R - 0.51499 * G - 0.10001 * B;
//	Y=pow(Y, newEBrightnessCurveV6);
//	Y=Y*newEBrightnessMultiplierV6;
//	Y=Y/(Y+newEBrightnessToneMappingCurveV6);
//	float	desaturatefact=saturate(Y*Y*Y*1.7);
//	U=lerp(U, 0.0, desaturatefact);
//	V=lerp(V, 0.0, desaturatefact);
//	color.xyz=V * float3(1.13983, -0.58060, 0.0) + U * float3(0.0, -0.39465, 2.03211) + Y;

//	color.xyz=max(color.xyz, 0.0);
//	color.xyz=color.xyz/(color.xyz+newEBrightnessToneMappingCurveV6);

		//dpeasant Colour Mood code

	float fRatio = lerp( fRatioInterior, ( lerp( fRatioNight, fRatioDay, hnd ) ), ji );

	float moodR = lerp( moodRInterior, ( lerp( moodRNight, moodRDay, hnd ) ), ji );
	float moodG = lerp( moodGInterior, ( lerp( moodGNight, moodGDay, hnd ) ), ji );
	float moodB = lerp( moodBInterior, ( lerp( moodBNight, moodBDay, hnd ) ), ji );

	float Exposure = lerp( ExposureInterior, ( lerp( ExposureNight, ExposureDay, hnd ) ), ji );
	float Contrast = lerp( ContrastInterior, ( lerp( ContrastNight, ContrastDay, hnd ) ), ji );

		float4 colInput = color;
		float4 colMood = 1.0f;
		colMood.r = moodR;
		colMood.g = moodG;
		colMood.b = moodB;
		float fLum = ( colInput.r + colInput.g + colInput.b ) / 3;

		colMood = lerp(0, colMood, saturate(fLum * 2.0));
		colMood = lerp(colMood, 1, saturate(fLum - 0.5) * 2.0);
		float4 colOutput = lerp(colInput, colMood, saturate(fLum * fRatio));
		color.rgb=max(0, colOutput);
		
		//dpeasant Contrast code
		color.xyz = saturate(color.xyz);
		color.xyz = lerp(color.xyz, 0.5 * (1 + sin((color.xyz - 0.5)*3.1415926)), Contrast);
	
		//dpeasant Exposure code
		color.rgb *= pow(2.0f, Exposure);

#endif
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#if (POSTPROCESS==7)

		float EAdaptationMaxV7 = lerp( EAdaptationMaxV7Interior, ( lerp( EAdaptationMaxV7Night, EAdaptationMaxV7Day, hnd ) ), ji );
		float EAdaptationMinV7 = lerp( EAdaptationMinV7Interior, ( lerp( EAdaptationMinV7Night, EAdaptationMinV7Day, hnd ) ), ji );
		float EIntensityContrastV7 = lerp( EIntensityContrastV7Interior, ( lerp( EIntensityContrastV7Night, EIntensityContrastV7Day, hnd ) ), ji );
		float EColorSaturationV7 = lerp( EColorSaturationV7Interior, ( lerp( EColorSaturationV7Night, EColorSaturationV7Day, hnd ) ), ji );
		float HCompensateSatV7 = lerp( HCompensateSatV7Interior, ( lerp( HCompensateSatV7Night, HCompensateSatV7Day, hnd ) ), ji );
		float EToneMappingCurveV7 = lerp( EToneMappingCurveV7Interior, ( lerp( EToneMappingCurveV7Night, EToneMappingCurveV7Day, hnd ) ), ji );

		float EBrightnessV7 = lerp( EBrightnessV7Interior, ( lerp( EBrightnessV7Night, EBrightnessV7Day, hnd ) ), ji );
		float EToneMappingOversaturationV7 = lerp( EToneMappingOversaturationV7Interior, ( lerp( EToneMappingOversaturationV7Night, EToneMappingOversaturationV7Day, hnd ) ), ji );
	
		grayadaptation=max(grayadaptation, 0.0);
		grayadaptation=min(grayadaptation, 50.0);
		color.xyz*=lerp( hndtweak.x, hndtweak.y, hnd );
		color.xyz*=EBrightnessV7; //[NOTE : Re-enabled brightness control] //Thanx MIDH !
		float3 xncol=normalize(color.xyz);
		float3 scl=color.xyz/xncol.xyz;
		scl=pow(scl, EIntensityContrastV7);
		xncol.xyz=pow(xncol.xyz, EColorSaturationV7);
		color.xyz=scl*xncol.xyz;
		color.xyz*=HCompensateSatV7; // compensate for darkening caused my EcolorSat above

		float lumamax=EToneMappingOversaturationV7;			
		color.xyz=(color.xyz * (1.0 + color.xyz/lumamax))/(color.xyz + EToneMappingCurveV7);			
		color.xyz=color.xyz/(color.xyz + EToneMappingCurveV7);

		//dpeasant Colour Mood code

	float fRatio = lerp( fRatioInterior, ( lerp( fRatioNight, fRatioDay, hnd ) ), ji );

	float moodR = lerp( moodRInterior, ( lerp( moodRNight, moodRDay, hnd ) ), ji );
	float moodG = lerp( moodGInterior, ( lerp( moodGNight, moodGDay, hnd ) ), ji );
	float moodB = lerp( moodBInterior, ( lerp( moodBNight, moodBDay, hnd ) ), ji );

	float Exposure = lerp( ExposureInterior, ( lerp( ExposureNight, ExposureDay, hnd ) ), ji );
	float Contrast = lerp( ContrastInterior, ( lerp( ContrastNight, ContrastDay, hnd ) ), ji );

		float4 colInput = color;
		float4 colMood = 1.0f;
		colMood.r = moodR;
		colMood.g = moodG;
		colMood.b = moodB;
		float fLum = ( colInput.r + colInput.g + colInput.b ) / 3;

		colMood = lerp(0, colMood, saturate(fLum * 2.0));
		colMood = lerp(colMood, 1, saturate(fLum - 0.5) * 2.0);
		float4 colOutput = lerp(colInput, colMood, saturate(fLum * fRatio));
		color.rgb=max(0, colOutput);
		
		//dpeasant Contrast code
		color.xyz = saturate(color.xyz);
		color.xyz = lerp(color.xyz, 0.5 * (1 + sin((color.xyz - 0.5)*3.1415926)), Contrast);
	
		//dpeasant Exposure code
		color.rgb *= pow(2.0f, Exposure);

#endif
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//-///////////////////////////////////////////////////////////////////////////////////////////
	//+++++++++++++++++++++++++++++
	//+++++++++++++++++++++++++++++
	//pallete texture (0.082+ version feature)
	#ifdef E_CC_PALETTE
		
		
		color.rgb=saturate(color.rgb);
		float3	brightness=Adaptation.xyz; //tex2D(_s4, 0.5); //adaptation luminance
			//brightness=saturate(brightness); //old version from ldr games
		brightness=(brightness/(brightness+1.0));//new version
		brightness=max(brightness.x, max(brightness.y, brightness.z));//new version
		float3	palette;
		float4	uvsrc=0.0;
		uvsrc.y=brightness.r;
		uvsrc.x=color.r;
		palette.r=tex2Dlod(_s7, uvsrc).r;
		uvsrc.x=color.g;
		uvsrc.y=brightness.g;
		palette.g=tex2Dlod(_s7, uvsrc).g;
		uvsrc.x=color.b;
		uvsrc.y=brightness.b;
		palette.b=tex2Dlod(_s7, uvsrc).b;		
		
		color.rgb=lerp( color.rgb, palette.rgb, palmix );
		
		//color.rgb=toobright;
	#endif //E_CC_PALETTE
	//+++++++++++++++++++++++++++++

	#ifdef ENABLE_SEPIATONE

		float fSepiaExposure = lerp( fSepiaExposureInterior, ( lerp( fSepiaExposureNight, fSepiaExposureDay, hnd ) ), ji );
		float fSepiaColor = lerp( fSepiaColorInterior, ( lerp( fSepiaColorNight, fSepiaColorDay, hnd ) ), ji );
		float fSepiaDesaturation = lerp( fSepiaDesaturationInterior, ( lerp( fSepiaDesaturationNight, fSepiaDesaturationDay, hnd ) ), ji );

	float SepiaWeight = float3( 0.2125, 0.7154, 0.0721 );
	float SepiaLuminance = min( 1.0, dot( color, SepiaWeight ) * fSepiaExposure ) ;
	float3 SepiaColor = fSepiaColor * SepiaLuminance;
	color.rgb = lerp( color.rgb, SepiaColor, fSepiaDesaturation );
	#endif

	#ifdef ENABLE_GRAIN

		float fGrainMotion = lerp( fGrainMotionInterior, ( lerp( fGrainMotionNight, fGrainMotionDay, hnd ) ), ji );
		float fGrainSaturation = lerp( fGrainSaturationInterior, ( lerp( fGrainSaturationNight, fGrainSaturationDay, hnd ) ), ji );
		float fGrainIntensity = lerp( fGrainIntensityInterior, ( lerp( fGrainIntensityNight, fGrainIntensityDay, hnd ) ), ji );

	float GrainTimerSeed = Timer.x * fGrainMotion;
	float2 GrainTexCoordSeed = _v0.xy * 1.0;
	float2 GrainSeed1 = GrainTexCoordSeed + float2( 0.0, GrainTimerSeed );
	float2 GrainSeed2 = GrainTexCoordSeed + float2( GrainTimerSeed, 0.0 );
	float2 GrainSeed3 = GrainTexCoordSeed + float2( GrainTimerSeed, GrainTimerSeed );
	float GrainNoise1 = random( GrainSeed1 );
	float GrainNoise2 = random( GrainSeed2 );
	float GrainNoise3 = random( GrainSeed3 );
	float GrainNoise4 = ( GrainNoise1 + GrainNoise2 + GrainNoise3 ) * 0.333333333;
	float3 GrainNoise = float3( GrainNoise4, GrainNoise4, GrainNoise4 );
	float3 GrainColor = float3( GrainNoise1, GrainNoise2, GrainNoise3 );
	color.rgb += ( lerp( GrainNoise, GrainColor, fGrainSaturation ) * fGrainIntensity ) - ( fGrainIntensity * 0.5);	//[KYO : modify this multiplier to intervene on Grain density]
	#endif

   _oC0.w=1.0;
   _oC0.xyz=color.xyz;

// [NOTE : Panoramic Offset - Letterbox effect code (by Matso)]
#ifdef USE_LETTERBOX_EFFECT

		float OFFSETInteriorFactor = 1 -  EInteriorFactor;
		float OFFSETNightDayFactor = 1 -  ENightDayFactor;
		#ifdef ENABLE_FLIP_INT_EXT_FACTOR
			OFFSETInteriorFactor = EInteriorFactor;
		#endif
		#ifdef ENABLE_FLIP_NITE_DAY_FACTOR
			OFFSETNightDayFactor = ENightDayFactor;
		#endif

	float fLetterboxOffset =lerp( lerp( fLetterboxOffsetDay, fLetterboxOffsetNight, OFFSETNightDayFactor ), fLetterboxOffsetInterior, OFFSETInteriorFactor );
	float offset = fLetterboxOffset * 0.01;
	float2 sspos = fvTexelSize * vPos;
	if (sspos.y <= offset || sspos.y >= (1.0 - offset)) _oC0.rgb = 0.0;
#endif	

   return _oC0;

	/*
	// HeliosDoubleSix cobbled code to Cap values above 0, not great as limits how black it can do say if it was pure red?!
	// what is the lowest value out of r,g,b
		float lowestvalue=min(min(color.x,color.y),color.z);
		// work out lowest possible value to set RGB without going below 0 and without changing the RGB relative values ie shifting the color in the process
		float3 lowestpossible=color.xyz-lowestvalue;
		color.xyz=max(color.xyz,lowestpossible);
		//color.r=max(color.r,lowestpossible.x);
		//color.g=max(color.g,lowestpossible.y);
		//color.b=max(color.b,lowestpossible.z);
	*/

		//color.xyz=saturate(xcolorbloom.xyz);
		//color.xyz-=(pow(color.xyz, 6)/2);
		//color.xyz=max(0,color.xyz);
		//color.xyz=debug;

	/*
		//temporary testing
		color.xyz=tex2D(_s0, _v0.xy);
		//color.xyz=xcolorbloom.xyz*tempF1.x;

		//color.xyz=pow(color.xyz, 0.5);
		color.xyz+=(xcolorbloom.xyz-color.xyz)*tempF1.y;
		//color.xyz=xcolorbloom.xyz*tempF1.y;
		color.xyz=color.xyz*tempF1.x;
		//color.xyz=color.xyz/(color.xyz +1.0*tempF1.z);
		color.xyz=(color.xyz * (1.0 + color.xyz/40))/(color.xyz + EToneMappingCurveV3);
			Adaptation=tex2D(_s4, 0.5);
			grayadaptation=max(max(Adaptation.x, Adaptation.y), Adaptation.z);
			grayadaptation=max(grayadaptation, 0.0);
			grayadaptation=min(grayadaptation, 50.0);
		//	color.xyz=Adaptation*2;//*tempF1.x

		//color.xyz=tex2D(_s0, _v0.xy)*1.3;
	*/

	//color.xyz=tex2D(_s0, _v0.xy)*pow(tempF1.x,4);
	//color.xyz=max(xcolorbloom.xyz, tex2D(_s0, _v0.xy).xyz)*pow(tempF1.x,4)*0.7;
 
	 
	_oC0.w=1.0;
	_oC0.xyz=color.xyz;
	//_oC0.xyz=debug;
	
	// HD6 - debug triangle - draws a triangle top left showing the value of night/day for testing
	//_oC0.xyz = _v0.x+_v0.y < 0.1 ? (hnd) : (_oC0.xyz);
	float h11 = h1 == 1 ? 0 : 0.4;
	_oC0.xyz += _v0.x+_v0.y < dotsize ? (h11) : (0);
	
	// Red dot in bottom left if you adjust daytime
	float h22 = h2 == 1 ? 0 : 0.4;
	_oC0.xyz += _v0.x+(1-_v0.y) < dotsize ? (h22) : (0);
	
	// White dot in top right if you adjust saturation
	float h33 = s1 == 1 ? 0 : 0.4;
	_oC0.xyz += (1-_v0.x)+_v0.y < dotsize ? (h33) : (0);

	return _oC0;
}

//switch between vanilla and PP1 to PP7
#ifndef ENB_FLIPTECHNIQUE
	technique Shader_D6EC7DD1
#else
	technique Shader_ORIGINALPOSTPROCESS
#endif
{
	pass p0
	{
		VertexShader = compile vs_3_0 VS_Quad();
		PixelShader = compile ps_3_0 PS_D6EC7DD1();

		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		ZEnable=FALSE;
		ZWriteEnable=FALSE;
		CullMode=NONE;
		AlphaTestEnable=FALSE;
		AlphaBlendEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
	}
}

// HD6 - below is disabled
/*
//original shader of post processing
#ifndef ENB_FLIPTECHNIQUE
	technique Shader_ORIGINALPOSTPROCESS
#else
	technique Shader_D6EC7DD1
#endif
{
	pass p0
	{
		VertexShader  = compile vs_3_0 VS_Quad();
		PixelShader=
	asm
	{
// Parameters:
//   sampler2D Avg;
//   sampler2D Blend;
//   float4 Cinematic;
//   float4 ColorRange;
//   float4 Fade;
//   sampler2D Image;
//   float4 Param;
//   float4 Tint;


// Registers:

//   Name         Reg   Size
//   ------------ ----- ----
//   ColorRange   c1       1
//   Param        c2       1
//   Cinematic    c3       1
//   Tint         c4       1
//   Fade         c5       1
//   Image        s0       1
//   Blend        s1       1
//   Avg          s2       1
//s0 bloom result
//s1 color
//s2 is average color

    ps_3_0
    def c6, 0, 0, 0, 0
    //was c0 originally
    def c7, 0.212500006, 0.715399981, 0.0720999986, 1
    dcl_texcoord v0.xy
    dcl_2d s0
    dcl_2d s1
    dcl_2d s2
    rcp r0.x, c2.y
    texld r1, v0, s2
    mul r0.yz, r1.xxyw, c1.y
    rcp r0.w, r0.y
    mul r0.z, r0.w, r0.z
    texld r1, v0, s1
    mul r1.xyz, r1, c1.y
    dp3 r0.w, c7, r1
    mul r1.w, r0.w, r0.z
    mad r0.z, r0.z, r0.w, c7.w
    rcp r0.z, r0.z
    mad r0.x, r1.w, r0.x, c7.w
    mul r0.x, r0.x, r1.w
    mul r0.x, r0.z, r0.x
    cmp r0.x, -r0.w, c6.x, r0.x
    rcp r0.z, r0.w
    mul r0.z, r0.z, r0.x
    add_sat r0.x, -r0.x, c2.x
    texld r2, v0, s0
    mul r2.xyz, r2, c1.y
    mul r2.xyz, r0.x, r2
    mad r1.xyz, r1, r0.z, r2
    dp3 r0.x, r1, c7
    mov r1.w, c7.w
    lrp r2, c3.x, r1, r0.x
    mad r1, r0.x, c4, -r2
    mad r1, c4.w, r1, r2
    mad r1, c3.w, r1, -r0.y
    mad r0, c3.z, r1, r0.y
    add r1, -r0, c5
    mad oC0, c5.w, r1, r0

	};
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		ZEnable=FALSE;
		ZWriteEnable=FALSE;
		CullMode=NONE;
		AlphaTestEnable=FALSE;
		AlphaBlendEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
    }
}
*/